/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.Base64;
import org.quattor.pan.utils.MessageUtils;

public final class Base64Encode
extends BuiltInFunction {
    private Base64Encode(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("base64_encode", sourceRange, operations);
        if (operations.length != 1) {
            throw SyntaxException.create(sourceRange, "MSG_INVALID_NO_ARGS_BASE64_ENCODE", new Object[0]);
        }
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        return new Base64Encode(sourceRange, operations);
    }

    public Element execute(Context context) {
        assert (this.ops.length == 1);
        Element result = this.ops[0].execute(context);
        try {
            String s = ((StringProperty)result).getValue();
            return StringProperty.getInstance(Base64.encodeBytes(s.getBytes()));
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_ARGS_BASE64_ENCODE", new Object[0]), this.sourceRange, context);
        }
    }
}

