/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.dml.operators.ListVariable;
import org.quattor.pan.dml.operators.Variable;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class Append
extends BuiltInFunction {
    protected Append(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("append", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        Operation value;
        if (operations.length < 1 || operations.length > 2) {
            throw SyntaxException.create(sourceRange, "MSG_ONE_OR_TWO_ARGS_REQ", "append");
        }
        assert (operations.length == 1 || operations.length == 2);
        Operation operation = value = operations.length == 1 ? operations[0] : operations[1];
        if (value instanceof Null) {
            throw SyntaxException.create(sourceRange, "MSG_VALUE_CANNOT_BE_NULL", "append");
        }
        if (operations.length == 2 && operations[0] instanceof Element && !(operations[0] instanceof ListResource)) {
            throw SyntaxException.create(sourceRange, "MSG_FIRST_ARG_LIST_OR_VARIABLE_REF", "append");
        }
        Operation[] modifiedOps = new Operation[2];
        if (operations.length == 1) {
            modifiedOps[0] = ListVariable.getInstance(sourceRange, "SELF", new Operation[0]);
            modifiedOps[1] = operations[0];
        } else if (operations.length == 2) {
            modifiedOps[0] = operations[0] instanceof Variable ? ListVariable.getInstance((Variable)operations[0]) : operations[0];
            modifiedOps[1] = operations[1];
        }
        return new Append(sourceRange, modifiedOps);
    }

    public Element execute(Context context) {
        ListResource result = null;
        Element[] args = this.calculateArgs(context);
        assert (this.ops.length == 2);
        if (args[1] instanceof Null) {
            throw EvaluationException.create(this.sourceRange, "MSG_VALUE_CANNOT_BE_NULL", this.name);
        }
        if (!(args[0] instanceof ListResource)) {
            throw EvaluationException.create(this.sourceRange, "MSG_FIRST_ARG_LIST_OR_VARIABLE_REF", this.name);
        }
        result = (ListResource)args[0];
        if (result.isProtected()) {
            result = (ListResource)result.writableCopy();
        }
        result.append(args[1]);
        return result;
    }
}

