/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import java.util.regex.Pattern;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.AbstractMatcher;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.SourceRange;

public abstract class AbstractStaticMatcher
extends AbstractMatcher {
    final Pattern pattern;

    protected AbstractStaticMatcher(SourceRange sourceRange, String functionName, Operation ... operations) throws SyntaxException {
        super(functionName, sourceRange, operations[0]);
        if (operations.length < 2 || operations.length > 3) {
            throw SyntaxException.create(sourceRange, "MSG_2_OR_3_ARGS", functionName);
        }
        if (!(operations[1] instanceof StringProperty) || operations.length > 2 && !(operations[2] instanceof StringProperty)) {
            throw CompilerError.create("MSG_INVALID_CALL_TO_STATIC_MATCHER", new Object[0]);
        }
        try {
            int flags = 0;
            if (operations.length == 3) {
                flags = this.convertMatchFlags((Element)operations[2]);
            }
            this.pattern = this.compilePattern((Element)operations[1], flags);
        }
        catch (EvaluationException ee) {
            throw SyntaxException.create(sourceRange, ee);
        }
    }
}

