/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.ant;

import java.io.File;
import java.util.LinkedList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.quattor.pan.Compiler;
import org.quattor.pan.CompilerOptions;
import org.quattor.pan.CompilerResults;
import org.quattor.pan.repository.SourceType;

public class PanCheckSyntaxTask
extends Task {
    private LinkedList<File> sourceFiles = new LinkedList();
    private boolean verbose = false;
    private int deprecationLevel = 0;

    public void execute() throws BuildException {
        CompilerOptions options = CompilerOptions.createCheckSyntaxOptions(this.deprecationLevel, false);
        CompilerResults results = Compiler.run(options, null, this.sourceFiles);
        boolean hadError = results.print(this.verbose);
        if (hadError) {
            throw new BuildException("Compilation failed; see messages.");
        }
    }

    public void addConfiguredFileSet(FileSet fileset) {
        this.addFiles(fileset);
    }

    private void addFiles(FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        File basedir = ds.getBasedir();
        for (String f : ds.getIncludedFiles()) {
            if (!SourceType.hasSourceFileExtension(f)) continue;
            this.sourceFiles.add(new File(basedir, f));
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDeprecationLevel(int deprecationLevel) {
        this.deprecationLevel = deprecationLevel;
    }
}

