/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.utils;

import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.quattor.pan.exceptions.CompilerError;

public class XmlUtils {
    private XmlUtils() {
    }

    public static TransformerHandler getSaxTransformerHandler() {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            if (!factory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
                throw CompilerError.create("MSG_MISSING_SAX_TRANSFORMER", new Object[0]);
            }
            try {
                factory.setAttribute("indent-number", 4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            SAXTransformerFactory saxfactory = (SAXTransformerFactory)factory;
            TransformerHandler handler = saxfactory.newTransformerHandler();
            Transformer transformer = handler.getTransformer();
            Properties properties = new Properties();
            properties.setProperty("indent", "yes");
            properties.setProperty("method", "xml");
            transformer.setOutputProperties(properties);
            return handler;
        }
        catch (TransformerConfigurationException tce) {
            CompilerError error = CompilerError.create("MSG_UNEXPECTED_EXCEPTION_WHILE_WRITING_OUTPUT", new Object[0]);
            error.initCause(tce);
            throw error;
        }
    }
}

