/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.utils;

import java.util.regex.Pattern;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.utils.Term;

public class TermFactory {
    private static final Pattern isIndexPattern = Pattern.compile("^\\d+$");
    private static final Pattern isIndexLeadingZerosPattern = Pattern.compile("^0\\d+$");
    private static final Pattern isKeyPattern = Pattern.compile("^\\w[\\w\\+\\-\\.]*$");
    private static final Term[] indexCache;

    private TermFactory() {
    }

    private static void checkNumericIndex(long index2) {
        if (index2 > Integer.MAX_VALUE) {
            throw EvaluationException.create("MSG_INDEX_EXCEEDS_MAXIMUM", index2, Integer.MAX_VALUE);
        }
        if (index2 < 0L) {
            throw EvaluationException.create("MSG_INDEX_CANNOT_BE_NEGATIVE", index2);
        }
    }

    private static long checkStringIndex(String term) {
        assert (term != null);
        long result = 0L;
        if ("".equals(term)) {
            throw EvaluationException.create("MSG_KEY_CANNOT_BE_EMPTY_STRING", new Object[0]);
        }
        if (isIndexPattern.matcher(term).matches()) {
            if (isIndexLeadingZerosPattern.matcher(term).matches()) {
                throw EvaluationException.create("MSG_INVALID_LEADING_ZEROS_INDEX", term);
            }
            try {
                result = Long.decode(term);
                TermFactory.checkNumericIndex(result);
            }
            catch (NumberFormatException nfe) {
                throw EvaluationException.create("MSG_KEY_CANNOT_BEGIN_WITH_DIGIT", term);
            }
        } else if (isKeyPattern.matcher(term).matches()) {
            result = -1L;
        } else {
            throw EvaluationException.create("MSG_INVALID_KEY", term);
        }
        return result;
    }

    public static Term create(String term) {
        long value = TermFactory.checkStringIndex(term);
        if (value < 0L) {
            return StringProperty.getInstance(term);
        }
        return TermFactory.create(value);
    }

    public static Term create(long index2) {
        TermFactory.checkNumericIndex(index2);
        if (index2 < (long)indexCache.length) {
            return indexCache[(int)index2];
        }
        return LongProperty.getInstance(index2);
    }

    public static Term create(Element element) {
        if (element instanceof StringProperty) {
            long value = TermFactory.checkStringIndex(((StringProperty)element).getValue());
            if (value < 0L) {
                return (Term)((Object)element);
            }
            return LongProperty.getInstance(value);
        }
        if (element instanceof LongProperty) {
            TermFactory.checkNumericIndex(((LongProperty)element).getValue());
            return (Term)((Object)element);
        }
        throw EvaluationException.create("MSG_INVALID_ELEMENT_FOR_INDEX", element.getTypeAsString());
    }

    public static int compare(Term self, Term other) {
        if (self == null || other == null) {
            throw new NullPointerException();
        }
        if (self == other) {
            return 0;
        }
        if (self.isKey() != other.isKey()) {
            return self.isKey() ? 1 : -1;
        }
        try {
            if (self.isKey()) {
                return self.getKey().compareTo(other.getKey());
            }
            return self.getIndex().compareTo(other.getIndex());
        }
        catch (InvalidTermException consumed) {
            assert (false);
            return 0;
        }
    }

    static {
        int size = 100;
        Term[] terms = new Term[size];
        for (int i = 0; i < size; ++i) {
            terms[i] = LongProperty.getInstance(i);
        }
        indexCache = terms;
    }
}

