/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Template;
import org.quattor.pan.utils.EscapeUtils;
import org.quattor.pan.utils.Term;
import org.quattor.pan.utils.TermFactory;

public class Path
implements Comparable<Path> {
    private String authority;
    private Term[] terms;
    private PathType type;
    private static Pattern extractAuthority = Pattern.compile("([^:]*):/?(.*)");
    private static Pattern validEscapeSequences = Pattern.compile("^([^\\{\\}]*+(\\{[^\\{\\}]*\\})?)*$");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Path(String path2) throws SyntaxException {
        assert (path2 != null);
        Matcher matcher = validEscapeSequences.matcher(path2);
        if (!matcher.matches()) {
            throw SyntaxException.create(null, "MSG_PATH_INVALID_BRACES", path2);
        }
        StringBuilder sb = new StringBuilder();
        String[] substrings = path2.split("[\\{\\}]", -1);
        for (int i = 0; i < substrings.length; ++i) {
            if (i % 2 == 0) {
                sb.append(substrings[i]);
                continue;
            }
            sb.append(EscapeUtils.escape(substrings[i]));
        }
        String s = path2 = sb.toString();
        this.type = PathType.RELATIVE;
        ArrayList<Term> xt = new ArrayList<Term>();
        if (path2.contains(":")) {
            this.type = PathType.EXTERNAL;
            Matcher m = extractAuthority.matcher(path2);
            if (!m.matches()) throw CompilerError.create("MSG_FILE_BUG_REPORT", new Object[0]);
            if (m.groupCount() != 2) throw CompilerError.create("MSG_FILE_BUG_REPORT", new Object[0]);
            String auth = m.group(1);
            s = m.group(2);
            if (!Template.isValidTemplateName(auth)) throw SyntaxException.create(null, "MSG_PATH_INVALID_AUTHORITY", auth);
            this.authority = auth;
        } else if (path2.startsWith("/")) {
            this.authority = null;
            this.type = PathType.ABSOLUTE;
            s = path2.substring(1);
        } else {
            this.authority = null;
        }
        if (s != null && !"".equals(s)) {
            for (String element : s.split("/")) {
                xt.add(TermFactory.create(element));
            }
        }
        if (this.type == PathType.RELATIVE && xt.size() == 0) {
            throw SyntaxException.create(null, "MSG_PATH_MISSING_TERM", new Object[0]);
        }
        if (xt.size() > 0 && !((Term)xt.get(0)).isKey()) {
            throw SyntaxException.create(null, "MSG_PATH_INVALID_FIRST_TERM", new Object[0]);
        }
        xt.trimToSize();
        this.terms = xt.toArray(new Term[xt.size()]);
    }

    public Path(Path root2, Term[] terms) throws SyntaxException {
        if (root2.isExternal()) {
            throw SyntaxException.create(null, "MSG_EXTERNAL_PATH_NOT_ALLOWED", new Object[0]);
        }
        this.type = root2.getType();
        this.authority = root2.authority;
        int size = root2.terms.length;
        if (terms != null) {
            size += terms.length;
        }
        Term[] result = new Term[size];
        System.arraycopy(root2.terms, 0, result, 0, root2.terms.length);
        if (terms != null) {
            System.arraycopy(terms, 0, result, root2.terms.length, terms.length);
        }
        this.terms = result;
    }

    public List<String> toList() {
        LinkedList<String> list = new LinkedList<String>();
        if (this.authority != null) {
            list.add(this.authority);
        }
        for (Term t : this.terms) {
            list.add(t.toString());
        }
        return list;
    }

    public Term[] getTerms() {
        return (Term[])this.terms.clone();
    }

    public static Path resolve(Path prefix, Path relative) throws SyntaxException {
        if (prefix != null && relative.isRelative()) {
            return new Path(prefix, relative.getTerms());
        }
        return relative;
    }

    public PathType getType() {
        return this.type;
    }

    public String getAuthority() {
        return this.authority;
    }

    public boolean isAbsolute() {
        return this.type == PathType.ABSOLUTE;
    }

    public boolean isRelative() {
        return this.type == PathType.RELATIVE;
    }

    public boolean isExternal() {
        return this.type == PathType.EXTERNAL;
    }

    public PathType getPathType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Path)) {
            return false;
        }
        Path p = (Path)obj;
        if (this.type != p.type) {
            return false;
        }
        if (this.authority != null && p.authority != null ? !this.authority.equals(p.authority) : this.authority != null || p.authority != null) {
            return false;
        }
        return Arrays.equals(this.terms, p.terms);
    }

    public int hashCode() {
        int code = this.type.hashCode();
        for (Term t : this.terms) {
            code ^= t.hashCode();
        }
        return code;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isExternal()) {
            sb.append(this.authority + ":/");
        }
        if (this.isAbsolute()) {
            sb.append("/");
        }
        boolean first = true;
        for (Term t : this.terms) {
            if (!first) {
                sb.append("/" + t.toString());
                continue;
            }
            sb.append(t.toString());
            first = false;
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Path o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.type != o.type) {
            return this.type.compareTo(o.type);
        }
        int mySize = this.terms.length;
        int otherSize = o.terms.length;
        if (mySize != otherSize) {
            return mySize < otherSize ? 1 : -1;
        }
        for (int i = 0; i < mySize; ++i) {
            Term myTerm = this.terms[i];
            Term otherTerm = o.terms[i];
            int comparison = myTerm.compareTo(otherTerm);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    public static enum PathType {
        RELATIVE,
        ABSOLUTE,
        EXTERNAL;

    }
}

