/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.utils;

import java.util.TreeMap;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.utils.Path;
import org.quattor.pan.utils.Term;

public class FinalFlags {
    private final Node root = new Node();

    public boolean isFinal(Path path2) {
        Node currentNode = this.root;
        for (Term t : path2.getTerms()) {
            Node nextNode = currentNode.getChild(t);
            if (nextNode == null) {
                return false;
            }
            if (nextNode.isFinal()) {
                return true;
            }
            currentNode = nextNode;
        }
        return currentNode.isFinal() || currentNode.hasChild();
    }

    public String getFinalReason(Path path2) {
        StringBuilder sb = new StringBuilder(path2 + " cannot be modified; ");
        StringBuilder finalPath = new StringBuilder("/");
        Node currentNode = this.root;
        for (Term t : path2.getTerms()) {
            finalPath.append(t.toString());
            Node nextNode = currentNode.getChild(t);
            if (nextNode == null) {
                return null;
            }
            if (nextNode.isFinal()) {
                sb.append(finalPath.toString() + " is marked as final");
                return sb.toString();
            }
            finalPath.append("/");
            currentNode = nextNode;
        }
        finalPath.deleteCharAt(finalPath.length() - 1);
        if (!currentNode.isFinal()) {
            if (currentNode.hasChild()) {
                sb.append(finalPath.toString() + currentNode.getFinalDescendantPath() + " is marked as final");
                return sb.toString();
            }
            return null;
        }
        sb.append(finalPath.toString() + " is marked as final");
        return null;
    }

    public void setFinal(Path path2) {
        Node currentNode = this.root;
        for (Term t : path2.getTerms()) {
            Node nextNode = currentNode.getChild(t);
            if (nextNode == null) {
                nextNode = currentNode.newChild(t);
            }
            currentNode = nextNode;
        }
        currentNode.setFinal();
    }

    private static class Node {
        private boolean flag = false;
        private final TreeMap<Term, Node> map = new TreeMap();

        public boolean isFinal() {
            return this.flag;
        }

        public void setFinal() {
            this.flag = true;
        }

        public Node getChild(Term term) {
            return this.map.get(term);
        }

        public boolean hasChild() {
            return this.map.size() != 0;
        }

        public String getFinalDescendantPath() {
            if (this.flag) {
                return "";
            }
            Term term = this.map.firstKey();
            return "/" + term.toString() + this.map.get(term).getFinalDescendantPath();
        }

        public Node newChild(Term term) {
            Node child = new Node();
            if (this.map.put(term, child) != null) {
                throw CompilerError.create("MSG_ATTEMPT_TO_REPLACE_EXISTING_NODE", new Object[0]);
            }
            return child;
        }
    }
}

