/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.utils;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;

public class FileStatCache {
    private final ConcurrentHashMap<File, Long> cachedTimes = new ConcurrentHashMap();

    public boolean exists(File file2) {
        return this.getModificationTime(file2) > 0L;
    }

    public boolean isMissingOrModifiedAfter(File file2, long targetTime) {
        long modtime = this.getModificationTime(file2);
        return modtime == 0L || modtime > targetTime;
    }

    public boolean isMissingOrModifiedBefore(File file2, long targetTime) {
        long modtime = this.getModificationTime(file2);
        return modtime == 0L || modtime < targetTime;
    }

    public long getModificationTime(File file2) {
        Long modtime = this.cachedTimes.get(file2);
        if (modtime == null) {
            this.cachedTimes.putIfAbsent(file2, file2.lastModified());
            modtime = this.cachedTimes.get(file2);
        }
        return modtime;
    }
}

