/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.type;

import clojure.lang.AFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.template.TypeMap;

public abstract class Type
extends AFn
implements IObj {
    private final AtomicReference<IPersistentMap> metadataRef = new AtomicReference();
    protected final String source;
    protected final String sourceRange;

    public Type(String source2, SourceRange sourceRange) {
        this.source = source2 != null ? source2 : "?";
        this.sourceRange = sourceRange != null ? sourceRange.toString() : "?";
    }

    @Override
    public IPersistentMap meta() {
        return this.metadataRef.get();
    }

    @Override
    public IObj withMeta(IPersistentMap iPersistentMap) {
        this.metadataRef.set(iPersistentMap);
        return this;
    }

    @Override
    public Object invoke(Object o1, Object o2) {
        try {
            return this.validate((Context)o1, (Element)o2);
        }
        catch (ClassCastException ex) {
            throw CompilerError.create("MSG_OPERATION_WITHOUT_CONTEXT", new Object[0]);
        }
    }

    public abstract void verifySubtypesDefined(TypeMap var1) throws EvaluationException;

    public abstract Object validate(Context var1, Element var2) throws ValidationException;

    public void validateAsIncludedType(Context context, Element self) throws ValidationException {
        throw ValidationException.create("MSG_CANNOT_INCLUDE_TYPE", new Object[0]);
    }

    public abstract Element setDefaults(Context var1, Element var2) throws EvaluationException;

    public abstract Element findDefault(Context var1);

    public String getSource() {
        return this.source;
    }

    public String getSourceRange() {
        return this.sourceRange;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

