/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.type;

import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.template.TypeMap;
import org.quattor.pan.type.BaseType;
import org.quattor.pan.type.FullType;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.Range;
import org.quattor.pan.utils.Term;

public class RecordType
extends BaseType {
    private final boolean extensible;
    private final Range range;
    private final String[] includes;
    private final Term[] reqKeys;
    private final FullType[] reqTypes;
    private final Term[] optKeys;
    private final FullType[] optTypes;

    public RecordType(String source2, SourceRange sourceRange, boolean extensible, Range range2, List<String> includes, SortedMap<Term, FullType> reqFields, SortedMap<Term, FullType> optFields) {
        super(source2, sourceRange);
        this.extensible = extensible;
        this.range = range2;
        String[] temp = (String[])Array.newInstance(String.class, includes.size());
        this.includes = includes.toArray(temp);
        int index2 = 0;
        int size = reqFields.size();
        this.reqKeys = new Term[size];
        this.reqTypes = new FullType[size];
        for (Map.Entry<Term, FullType> entry : reqFields.entrySet()) {
            this.reqKeys[index2] = entry.getKey();
            this.reqTypes[index2] = entry.getValue();
            ++index2;
        }
        index2 = 0;
        size = optFields.size();
        this.optKeys = new Term[size];
        this.optTypes = new FullType[size];
        for (Map.Entry<Term, FullType> entry : optFields.entrySet()) {
            this.optKeys[index2] = entry.getKey();
            this.optTypes[index2] = entry.getValue();
            ++index2;
        }
    }

    @Override
    public void verifySubtypesDefined(TypeMap types) {
        for (String string2 : this.includes) {
            FullType fullType = types.get(string2);
            if (fullType != null) {
                BaseType baseType = fullType.getBaseType();
                if (baseType instanceof RecordType) continue;
                throw new EvaluationException(MessageUtils.format("MSG_NONRECORD_TYPE_REF", string2));
            }
            throw new EvaluationException(MessageUtils.format("MSG_NONEXISTANT_REFERENCED_TYPE", string2));
        }
        for (FullType fullType : this.reqTypes) {
            fullType.verifySubtypesDefined(types);
        }
        for (FullType fullType : this.optTypes) {
            fullType.verifySubtypesDefined(types);
        }
    }

    @Override
    public Element findDefault(Context context) throws EvaluationException {
        Element defaultValue = null;
        try {
            for (String s : this.includes) {
                try {
                    FullType type2 = context.getFullType(s);
                    defaultValue = type2.findDefault(context);
                    if (defaultValue == null) continue;
                    break;
                }
                catch (NullPointerException npe) {
                    throw CompilerError.create("MSG_NONEXISTANT_REFERENCED_TYPE", s);
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return defaultValue;
    }

    @Override
    public Element setDefaults(Context context, Element self) throws EvaluationException {
        assert (self != null);
        HashResource dict = null;
        try {
            Element defaultValue;
            Element newValue;
            Element child;
            int i;
            dict = (HashResource)self;
            for (String s : this.includes) {
                FullType type2 = context.getFullType(s);
                try {
                    HashResource replacement = (HashResource)type2.setDefaults(context, dict);
                    if (replacement == null) continue;
                    dict = replacement;
                }
                catch (NullPointerException npe) {
                    throw CompilerError.create("MSG_NONEXISTANT_REFERENCED_TYPE", s);
                }
            }
            for (i = 0; i < this.reqKeys.length; ++i) {
                Term term = this.reqKeys[i];
                FullType fullType = this.reqTypes[i];
                try {
                    child = dict.get(term);
                    if (child != null && !(child instanceof Undef)) {
                        newValue = fullType.setDefaults(context, child);
                        if (newValue == null) continue;
                        if (dict.isProtected()) {
                            dict = (HashResource)dict.writableCopy();
                        }
                        dict.put(term, newValue);
                        continue;
                    }
                    defaultValue = fullType.findDefault(context);
                    if (defaultValue == null) continue;
                    if (dict.isProtected()) {
                        dict = (HashResource)dict.writableCopy();
                    }
                    dict.put(term, defaultValue);
                    Element newValue2 = fullType.setDefaults(context, defaultValue);
                    if (newValue2 == null) continue;
                    if (dict.isProtected()) {
                        dict = (HashResource)dict.writableCopy();
                    }
                    dict.put(term, newValue2);
                    continue;
                }
                catch (InvalidTermException ite) {
                    throw CompilerError.create("MSG_INVALID_KEY_OR_INDEX", new Object[0]);
                }
            }
            for (i = 0; i < this.optKeys.length; ++i) {
                Term term = this.optKeys[i];
                FullType fullType = this.optTypes[i];
                try {
                    child = dict.get(term);
                    if (child == null) continue;
                    if (child instanceof Undef && (defaultValue = fullType.findDefault(context)) != null) {
                        if (dict.isProtected()) {
                            dict = (HashResource)dict.writableCopy();
                        }
                        dict.put(term, defaultValue);
                        child = defaultValue;
                    }
                    if ((newValue = fullType.setDefaults(context, child)) == null) continue;
                    if (dict.isProtected()) {
                        dict = (HashResource)dict.writableCopy();
                    }
                    dict.put(term, newValue);
                    continue;
                }
                catch (InvalidTermException ite) {
                    throw CompilerError.create("MSG_INVALID_KEY_OR_INDEX", new Object[0]);
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return self == dict ? null : dict;
    }

    private void removeDefinedFields(Context context, List<Term> undefinedFields) throws ValidationException {
        for (Term term : this.reqKeys) {
            undefinedFields.remove(term);
        }
        for (Term term : this.optKeys) {
            undefinedFields.remove(term);
        }
        for (String s : this.includes) {
            try {
                FullType fullType = context.getFullType(s);
                BaseType baseType = fullType.getBaseType();
                RecordType recordType = (RecordType)baseType;
                recordType.removeDefinedFields(context, undefinedFields);
            }
            catch (ClassCastException cce) {
                throw CompilerError.create("MSG_NONRECORD_TYPE_REF", s);
            }
            catch (NullPointerException npe) {
                throw CompilerError.create("MSG_NONEXISTANT_REFERENCED_TYPE", s);
            }
        }
    }

    @Override
    public Object validate(Context context, Element self) throws ValidationException {
        if (!this.extensible) {
            try {
                HashResource dict = (HashResource)self;
                LinkedList<Term> undefinedFields = new LinkedList<Term>();
                for (Term term : dict.keySet()) {
                    undefinedFields.add(term);
                }
                this.removeDefinedFields(context, undefinedFields);
                if (undefinedFields.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (Term term : undefinedFields) {
                        sb.append(term.toString());
                        sb.append(" ");
                    }
                    throw ValidationException.create("MSG_UNEXPECTED_FIELDS", sb.toString());
                }
            }
            catch (ClassCastException cce) {
                throw ValidationException.create("MSG_MISMATCHED_TYPES", "dict", self.getTypeAsString());
            }
        }
        this.validateAsIncludedType(context, self);
        return null;
    }

    @Override
    public void validateAsIncludedType(Context context, Element self) throws ValidationException {
        try {
            Element child;
            int i;
            HashResource dict = (HashResource)self;
            if (this.range != null) {
                dict.checkRange(this.range);
            }
            for (String s : this.includes) {
                FullType fullType = context.getFullType(s);
                try {
                    if (!(fullType.getBaseType() instanceof RecordType)) {
                        throw CompilerError.create("MSG_NONRECORD_TYPE_REF", s);
                    }
                    fullType.validateAsIncludedType(context, self);
                }
                catch (ValidationException ve) {
                    throw ve.addTypeToStack(s, fullType);
                }
                catch (NullPointerException npe) {
                    throw CompilerError.create("MSG_NONEXISTANT_REFERENCED_TYPE", s);
                }
            }
            for (i = 0; i < this.reqKeys.length; ++i) {
                Term term = this.reqKeys[i];
                FullType fullType = this.reqTypes[i];
                try {
                    child = dict.get(term);
                    if (child != null) {
                        try {
                            fullType.validate(context, child);
                            continue;
                        }
                        catch (ValidationException ve) {
                            throw ve.addTerm(term);
                        }
                    }
                    throw ValidationException.create("MSG_MISSING_FIELD", term);
                }
                catch (InvalidTermException ite) {
                    throw CompilerError.create("MSG_INVALID_KEY_OR_INDEX", new Object[0]);
                }
            }
            for (i = 0; i < this.optKeys.length; ++i) {
                Term term = this.optKeys[i];
                FullType fullType = this.optTypes[i];
                try {
                    child = dict.get(term);
                    if (child == null) continue;
                    try {
                        fullType.validate(context, child);
                        continue;
                    }
                    catch (ValidationException ve) {
                        throw ve.addTerm(term);
                    }
                }
                catch (InvalidTermException ite) {
                    throw CompilerError.create("MSG_INVALID_KEY_OR_INDEX", new Object[0]);
                }
            }
        }
        catch (ClassCastException cce) {
            throw ValidationException.create("MSG_MISMATCHED_TYPES", "dict", self.getTypeAsString());
        }
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        if (this.extensible) {
            sb.append("extensible ");
        }
        sb.append("{\n");
        for (String s : this.includes) {
            sb.append("\tinclude ");
            sb.append(s);
            sb.append("\n");
        }
        for (i = 0; i < this.reqKeys.length; ++i) {
            sb.append("\n" + this.reqKeys[i] + " : " + this.reqTypes[i] + "\n");
        }
        for (i = 0; i < this.optKeys.length; ++i) {
            sb.append("\n" + this.optKeys[i] + " ? " + this.optTypes[i] + "\n");
        }
        sb.append("}");
        if (this.range != null) {
            sb.append(" (");
            sb.append(this.range.toString());
            sb.append(")");
        }
        sb.append("\n");
        return sb.toString();
    }
}

