/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.type;

import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.type.BaseType;
import org.quattor.pan.type.CompositeType;
import org.quattor.pan.utils.Range;
import org.quattor.pan.utils.Term;
import org.quattor.pan.utils.TermFactory;

public class ListType
extends CompositeType {
    public ListType(String source2, SourceRange sourceRange, BaseType baseType, Range range2) {
        super(source2, sourceRange, baseType, range2);
    }

    @Override
    public Element findDefault(Context context) {
        return null;
    }

    @Override
    public Element setDefaults(Context context, Element self) throws EvaluationException {
        ListResource replacement = null;
        try {
            ListResource list = (ListResource)self;
            for (int i = 0; i < list.size(); ++i) {
                Term t = TermFactory.create(i);
                Element child = list.get(t);
                Element newValue = this.baseType.setDefaults(context, child);
                if (newValue == null) continue;
                if (replacement == null) {
                    replacement = (ListResource)list.writableCopy();
                }
                replacement.put(t, newValue);
            }
        }
        catch (ClassCastException list) {
        }
        catch (InvalidTermException ite) {
            throw CompilerError.create("MSG_INVALID_KEY_OR_INDEX", new Object[0]);
        }
        return replacement;
    }

    @Override
    public Object validate(Context context, Element self) throws ValidationException {
        try {
            ListResource list = (ListResource)self;
            if (this.range != null) {
                list.checkRange(this.range);
            }
            for (int i = 0; i < list.size(); ++i) {
                Term t = TermFactory.create(i);
                try {
                    Element child = list.get(t);
                    this.baseType.validate(context, child);
                    continue;
                }
                catch (ValidationException ve) {
                    throw ve.addTerm(t);
                }
                catch (InvalidTermException ite) {
                    throw CompilerError.create("MSG_INVALID_KEY_OR_INDEX", new Object[0]);
                }
            }
        }
        catch (ClassCastException cce) {
            throw ValidationException.create("MSG_MISMATCHED_TYPES", "list", self.getTypeAsString());
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.range == null) {
            return this.baseType.toString() + "[]";
        }
        return this.baseType.toString() + "[" + this.range + "]";
    }
}

