/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.type;

import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.type.BaseType;
import org.quattor.pan.type.CompositeType;
import org.quattor.pan.utils.Path;

public class LinkType
extends CompositeType {
    public LinkType(String source2, SourceRange sourceRange, BaseType baseType) {
        super(source2, sourceRange, baseType, null);
    }

    @Override
    public Element findDefault(Context context) {
        return null;
    }

    @Override
    public Element setDefaults(Context context, Element self) throws EvaluationException {
        try {
            StringProperty link = (StringProperty)self;
            try {
                Path path2 = new Path(link.getValue());
                Element linkedElement = context.getElement(path2);
                Element linkedReplacement = null;
                if (linkedElement != null) {
                    linkedReplacement = this.baseType.setDefaults(context, linkedElement);
                }
                if (linkedReplacement != null) {
                    context.putElement(path2, linkedReplacement);
                }
            }
            catch (SyntaxException syntaxException) {
            }
            catch (EvaluationException evaluationException) {}
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Object validate(Context context, Element self) throws ValidationException {
        try {
            StringProperty link = (StringProperty)self;
            Path path2 = null;
            try {
                path2 = new Path(link.getValue());
            }
            catch (SyntaxException se) {
                throw ValidationException.create("MSG_INVALID_LINK_PATH", link.getValue());
            }
            Element linkedElement = null;
            try {
                linkedElement = context.getElement(path2);
                if (linkedElement == null) {
                    throw ValidationException.create("MSG_NONEXISTANT_LINK_ELEMENT", path2);
                }
            }
            catch (EvaluationException ee) {
                throw ValidationException.create("MSG_PATH_EVAL_ERROR", path2, ee.getSimpleMessage());
            }
            try {
                this.baseType.validate(context, linkedElement);
            }
            catch (ValidationException ve) {
                ValidationException envelope = ValidationException.create("MSG_LINK_ELEMENT_FAILED_VALIDATION", path2);
                envelope.initCause(ve);
                throw envelope;
            }
        }
        catch (ClassCastException cce) {
            throw ValidationException.create("MSG_CONFLICTING_TYPES", "link", self.getTypeAsString());
        }
        return null;
    }

    @Override
    public String toString() {
        return this.baseType.toString() + "*";
    }
}

