/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.type;

import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.type.BaseType;
import org.quattor.pan.type.CompositeType;
import org.quattor.pan.utils.Range;
import org.quattor.pan.utils.Term;

public class HashType
extends CompositeType {
    public HashType(String source2, SourceRange sourceRange, BaseType baseType, Range range2) {
        super(source2, sourceRange, baseType, range2);
    }

    @Override
    public Element findDefault(Context context) {
        return null;
    }

    @Override
    public Element setDefaults(Context context, Element self) throws EvaluationException {
        assert (context != null);
        assert (self != null);
        HashResource replacement = null;
        try {
            HashResource dict = (HashResource)self;
            for (Term t : dict.keySet()) {
                Element child = dict.get(t);
                Element newValue = this.baseType.setDefaults(context, child);
                if (newValue == null) continue;
                if (replacement == null) {
                    replacement = (HashResource)dict.writableCopy();
                }
                replacement.put(t, newValue);
            }
        }
        catch (ClassCastException dict) {
        }
        catch (InvalidTermException ite) {
            throw CompilerError.create("MSG_INVALID_KEY_OR_INDEX", new Object[0]);
        }
        return replacement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object validate(Context context, Element self) throws ValidationException {
        try {
            HashResource dict = (HashResource)self;
            if (this.range != null) {
                dict.checkRange(this.range);
            }
            for (Term t : dict.keySet()) {
                try {
                    Element child = dict.get(t);
                    this.baseType.validate(context, child);
                }
                catch (ValidationException ve) {
                    throw ve.addTerm(t);
                }
                catch (InvalidTermException ite) {
                    throw CompilerError.create("MSG_INVALID_KEY_OR_INDEX", new Object[0]);
                    return null;
                }
            }
        }
        catch (ClassCastException cce) {
            throw ValidationException.create("MSG_MISMATCHED_TYPES", "dict", self.getTypeAsString());
        }
    }

    @Override
    public String toString() {
        if (this.range == null) {
            return this.baseType.toString() + "{}";
        }
        return this.baseType.toString() + "{" + this.range + "}";
    }
}

