/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.type;

import java.util.ArrayList;
import java.util.List;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.type.AdvancedType;
import org.quattor.pan.type.FullType;

public class ChoiceType
extends AdvancedType {
    private List<Element> choices;

    public ChoiceType(String source2, SourceRange sourceRange, List<Element> choices) {
        super(source2, sourceRange, "string");
        this.choices = choices;
    }

    @Override
    public Object validate(Context context, Element self) {
        FullType type2 = context.getFullType(this.identifier);
        type2.validate(context, self);
        System.out.println(this.toString());
        boolean found = this.choices.contains(self);
        if (!found) {
            throw ValidationException.create("MSG_INVALID_CHOICE_TYPE", self.toString());
        }
        return null;
    }

    @Override
    public Element setDefaults(Context context, Element self) throws EvaluationException {
        return null;
    }

    @Override
    public String toString() {
        ArrayList<String> list = new ArrayList<String>();
        for (Element e2 : this.choices) {
            list.add(((StringProperty)e2).getValue());
        }
        return "choice(" + String.join((CharSequence)", ", list) + ")";
    }
}

