/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.type;

import org.quattor.pan.dml.data.Element;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.template.TypeMap;
import org.quattor.pan.type.BaseType;
import org.quattor.pan.type.FullType;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.Range;

public class AliasType
extends BaseType {
    private final String identifier;
    private final Range range;

    public AliasType(String source2, SourceRange sourceRange, String identifier, Range range2) {
        super(source2, sourceRange);
        assert (identifier != null);
        this.identifier = identifier;
        this.range = range2;
    }

    @Override
    public Element findDefault(Context context) {
        try {
            FullType type2 = context.getFullType(this.identifier);
            return type2.findDefault(context);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            throw CompilerError.create("MSG_NONEXISTANT_TYPE", this.identifier);
        }
    }

    @Override
    public Element setDefaults(Context context, Element self) throws EvaluationException {
        assert (context != null);
        assert (self != null);
        Element replacement = null;
        try {
            FullType type2 = context.getFullType(this.identifier);
            replacement = type2.setDefaults(context, self);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            throw CompilerError.create("MSG_NONEXISTANT_TYPE", this.identifier);
        }
        return replacement;
    }

    @Override
    public Object validate(Context context, Element self) throws ValidationException {
        FullType type2 = context.getFullType(this.identifier);
        try {
            type2.validate(context, self);
            if (this.range != null) {
                self.checkRange(this.range);
            }
        }
        catch (ValidationException ve) {
            throw ve.addTypeToStack(this.identifier, type2);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            throw CompilerError.create("MSG_NONEXISTANT_TYPE", this.identifier);
        }
        return null;
    }

    @Override
    public void verifySubtypesDefined(TypeMap types) {
        if (types.get(this.identifier) == null) {
            throw new EvaluationException(MessageUtils.format("MSG_NONEXISTANT_REFERENCED_TYPE", this.identifier));
        }
    }

    @Override
    public String toString() {
        if (this.range == null) {
            return this.identifier;
        }
        return this.identifier + "(" + this.range.toString() + ")";
    }
}

