/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.template;

import clojure.lang.AFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.repository.SourceFile;
import org.quattor.pan.statement.AssignmentStatement;
import org.quattor.pan.statement.BindStatement;
import org.quattor.pan.statement.FunctionStatement;
import org.quattor.pan.statement.IncludeStatement;
import org.quattor.pan.statement.Statement;
import org.quattor.pan.statement.TypeStatement;
import org.quattor.pan.statement.VariableStatement;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public class Template
extends AFn
implements IObj {
    private final AtomicReference<IPersistentMap> metadataRef = new AtomicReference();
    private static final boolean[][] allowedIncludes;
    public static final Pattern validTemplateNameChars;
    public final SourceFile sourceFile;
    public final File source;
    public final String name;
    public final TemplateType type;
    private final Statement[] staticStatements;
    private final Statement[] normalStatements;
    private static final Statement[] emptyStatements;

    public Template(String name2) throws SyntaxException {
        this(null, null, TemplateType.OBJECT, name2, null);
    }

    public Template(File source2, SourceRange sourceRange, TemplateType type2, String name2, List<Statement> statements) throws SyntaxException {
        AssignmentStatement stmt;
        try {
            this.sourceFile = new SourceFile(name2, true, source2);
        }
        catch (IllegalArgumentException e2) {
            throw new SyntaxException(e2.getMessage(), sourceRange, source2);
        }
        this.name = this.sourceFile.getName();
        this.source = this.sourceFile.getPath();
        assert (type2 != null);
        this.type = type2;
        if (statements == null) {
            statements = new LinkedList<Statement>();
        }
        ArrayList<Statement> ss = new ArrayList<Statement>(statements.size());
        ArrayList<Statement> ns2 = new ArrayList<Statement>(statements.size());
        for (Statement s : statements) {
            ss.add(s);
            if (type2 == TemplateType.UNIQUE || type2 == TemplateType.DECLARATION || s instanceof FunctionStatement || s instanceof TypeStatement || s instanceof BindStatement) continue;
            ns2.add(s);
        }
        this.staticStatements = ss.size() > 0 ? ss.toArray(new Statement[ss.size()]) : emptyStatements;
        this.normalStatements = ss.size() == ns2.size() ? this.staticStatements : (ns2.size() > 0 ? ns2.toArray(new Statement[ns2.size()]) : emptyStatements);
        if (type2 == TemplateType.DECLARATION) {
            for (Statement s : this.staticStatements) {
                if (s instanceof FunctionStatement || s instanceof TypeStatement || s instanceof IncludeStatement || s instanceof BindStatement || s instanceof VariableStatement) continue;
                throw SyntaxException.create(s.getSourceRange(), source2, "MSG_INVALID_STMT_IN_DECL_TPL", new Object[0]);
            }
        }
        if (type2 == TemplateType.STRUCTURE) {
            for (Statement s : this.staticStatements) {
                if (s instanceof VariableStatement || s instanceof BindStatement || s instanceof FunctionStatement || s instanceof TypeStatement) {
                    throw SyntaxException.create(s.getSourceRange(), source2, "MSG_INVALID_STATEMENT_IN_STRUCT_TPL", new Object[0]);
                }
                if (!(s instanceof AssignmentStatement) || !(stmt = (AssignmentStatement)s).isAbsolute()) continue;
                throw SyntaxException.create(s.getSourceRange(), source2, "MSG_ONLY_REL_ASSIGNMENT_ALLOWED", new Object[0]);
            }
        }
        if (type2 != TemplateType.STRUCTURE && type2 != TemplateType.DECLARATION) {
            for (Statement s : this.staticStatements) {
                if (!(s instanceof AssignmentStatement) || !(stmt = (AssignmentStatement)s).isRelative()) continue;
                throw SyntaxException.create(s.getSourceRange(), source2, "MSG_ONLY_ABS_ASSIGNMENT_ALLOWED", new Object[0]);
            }
        }
        HashMap<String, SourceRange> mdefns = new HashMap<String, SourceRange>();
        for (Statement s : this.staticStatements) {
            SourceRange oldvalue;
            if (s instanceof TypeStatement) {
                TypeStatement ts = (TypeStatement)s;
                oldvalue = mdefns.put("T$" + ts.getName(), ts.getSourceRange());
                if (oldvalue == null) continue;
                throw SyntaxException.create(ts.getSourceRange(), source2, "MSG_MULTIPLY_DEFINED_TYPE", ts.getName(), oldvalue);
            }
            if (!(s instanceof FunctionStatement)) continue;
            FunctionStatement fs = (FunctionStatement)s;
            oldvalue = mdefns.put("F$" + fs.getName(), fs.getSourceRange());
            if (oldvalue == null) continue;
            throw SyntaxException.create(fs.getSourceRange(), source2, "MSG_MULTIPLY_DEFINED_FUNCTION", fs.getName(), oldvalue);
        }
        if ((type2 == TemplateType.UNIQUE || type2 == TemplateType.DECLARATION) && this.normalStatements.length != 0) {
            throw CompilerError.create("MSG_TEMPLATE_CONTAINS_NON_STATIC_STATEMENTS", new Object[0]);
        }
    }

    public static boolean isValidTemplateName(String name2) {
        if (!validTemplateNameChars.matcher(name2).matches()) {
            return false;
        }
        for (String t : name2.split("/")) {
            if (!"".equals(t) && !t.startsWith(".")) continue;
            return false;
        }
        return true;
    }

    @Override
    public IPersistentMap meta() {
        return this.metadataRef.get();
    }

    @Override
    public IObj withMeta(IPersistentMap iPersistentMap) {
        this.metadataRef.set(iPersistentMap);
        return this;
    }

    @Override
    public Object invoke(Object o1, Object o2) {
        try {
            return this.execute((Context)o1, (Boolean)o2);
        }
        catch (ClassCastException ex) {
            throw CompilerError.create("MSG_OPERATION_WITHOUT_CONTEXT", new Object[0]);
        }
    }

    public Object execute(Context context, boolean runStatic) {
        for (Statement s : runStatic ? this.staticStatements : this.normalStatements) {
            s.execute(context);
        }
        return null;
    }

    public static boolean checkValidInclude(TemplateType includeeType, TemplateType includedType) {
        return allowedIncludes[includeeType.ordinal()][includedType.ordinal()];
    }

    public void templateNameVerification(String expectedName) throws SyntaxException {
        if (!this.name.equals(expectedName)) {
            throw SyntaxException.create(null, this.source, "MSG_MISNAMED_TPL", expectedName);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.toString());
        sb.append(" template ");
        sb.append(this.name);
        sb.append("\n");
        sb.append("Source: ");
        sb.append(this.source.toString());
        sb.append("\n");
        for (Statement s : this.staticStatements) {
            sb.append(s.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    static {
        TemplateType[] allTypes = TemplateType.values();
        int maxIndex = 0;
        for (TemplateType t : allTypes) {
            int ordinal = t.ordinal();
            if (ordinal <= maxIndex) continue;
            maxIndex = ordinal;
        }
        allowedIncludes = new boolean[maxIndex + 1][maxIndex + 1];
        for (TemplateType t1 : allTypes) {
            for (TemplateType t2 : allTypes) {
                Template.allowedIncludes[t1.ordinal()][t2.ordinal()] = false;
            }
        }
        Template.allowedIncludes[TemplateType.OBJECT.ordinal()][TemplateType.ORDINARY.ordinal()] = true;
        Template.allowedIncludes[TemplateType.OBJECT.ordinal()][TemplateType.DECLARATION.ordinal()] = true;
        Template.allowedIncludes[TemplateType.OBJECT.ordinal()][TemplateType.UNIQUE.ordinal()] = true;
        Template.allowedIncludes[TemplateType.ORDINARY.ordinal()][TemplateType.ORDINARY.ordinal()] = true;
        Template.allowedIncludes[TemplateType.ORDINARY.ordinal()][TemplateType.DECLARATION.ordinal()] = true;
        Template.allowedIncludes[TemplateType.ORDINARY.ordinal()][TemplateType.UNIQUE.ordinal()] = true;
        Template.allowedIncludes[TemplateType.UNIQUE.ordinal()][TemplateType.ORDINARY.ordinal()] = true;
        Template.allowedIncludes[TemplateType.UNIQUE.ordinal()][TemplateType.DECLARATION.ordinal()] = true;
        Template.allowedIncludes[TemplateType.UNIQUE.ordinal()][TemplateType.UNIQUE.ordinal()] = true;
        Template.allowedIncludes[TemplateType.STRUCTURE.ordinal()][TemplateType.DECLARATION.ordinal()] = true;
        Template.allowedIncludes[TemplateType.STRUCTURE.ordinal()][TemplateType.STRUCTURE.ordinal()] = true;
        Template.allowedIncludes[TemplateType.DECLARATION.ordinal()][TemplateType.DECLARATION.ordinal()] = true;
        validTemplateNameChars = Pattern.compile("^[\\w\\./+-]+$");
        emptyStatements = new Statement[0];
    }

    public static enum TemplateType {
        ORDINARY,
        OBJECT,
        DECLARATION,
        STRUCTURE,
        UNIQUE;

    }
}

