/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.template;

public class SourceRange {
    private final int beginLine;
    private final int beginColumn;
    private final int endLine;
    private final int endColumn;

    public SourceRange(int beginLine, int beginColumn, int endLine, int endColumn) {
        if (beginLine < 1) {
            throw new IllegalArgumentException("beginLine must be positive");
        }
        if (beginColumn < 1) {
            throw new IllegalArgumentException("beginLine must be positive");
        }
        if (endLine < 1) {
            throw new IllegalArgumentException("endLine must be positive");
        }
        if (endColumn < 1) {
            throw new IllegalArgumentException("endLine must be positive");
        }
        if (endLine < beginLine) {
            throw new IllegalArgumentException("endLine must be the same or larger than beginLine");
        }
        if (endLine == beginLine && endColumn < beginColumn) {
            throw new IllegalArgumentException("endLine must be the same or larger than beginLine");
        }
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public String toString() {
        return this.beginLine + "." + this.beginColumn + "-" + this.endLine + "." + this.endColumn;
    }

    public static SourceRange combineSourceRanges(SourceRange ... ranges) {
        SourceRange r;
        int i;
        int bline = 0;
        int bcol = 0;
        int eline = 0;
        int ecol = 0;
        int firstIndex = -1;
        for (i = 0; i < ranges.length; ++i) {
            r = ranges[i];
            if (r == null) continue;
            bline = r.beginLine;
            bcol = r.beginColumn;
            eline = r.endLine;
            ecol = r.endColumn;
            firstIndex = i + 1;
            break;
        }
        if (firstIndex < 0) {
            return null;
        }
        for (i = firstIndex; i < ranges.length; ++i) {
            r = ranges[i];
            if (r == null) continue;
            if (r.beginLine < bline) {
                bline = r.beginLine;
                bcol = r.beginColumn;
            } else if (r.beginLine == bline && r.beginColumn < bcol) {
                bcol = r.beginColumn;
            }
            if (r.endLine < eline) {
                eline = r.endLine;
                ecol = r.endColumn;
                continue;
            }
            if (r.endLine != eline || r.endColumn <= ecol) continue;
            ecol = r.endColumn;
        }
        return new SourceRange(bline, bcol, eline, ecol);
    }
}

