/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.template;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quattor.pan.CompilerLogging;
import org.quattor.pan.CompilerOptions;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.ReturnValueException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.repository.SourceFile;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.IteratorMap;
import org.quattor.pan.template.LocalVariableMap;
import org.quattor.pan.template.ReadOnlySelfHolder;
import org.quattor.pan.template.SelfHolder;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.template.Template;
import org.quattor.pan.type.FullType;
import org.quattor.pan.utils.FunctionDefinition;
import org.quattor.pan.utils.GlobalVariable;
import org.quattor.pan.utils.Path;
import org.quattor.pan.utils.SourceLocation;
import org.quattor.pan.utils.Term;

public class CompileTimeContext
implements Context {
    private static final String TPL_VAR = "TEMPLATE";
    private static final Logger callLogger = CompilerLogging.LoggingType.CALL.logger();
    private LocalVariableMap localVariables;
    private final Stack<SourceLocation> templates;
    private Template currentTemplate;
    private final Template objectTemplate;
    private IteratorMap iteratorMap;
    public final CompilerOptions.DeprecationWarnings deprecationWarnings = CompilerOptions.DeprecationWarnings.OFF;
    private static final Template emptyTemplate;

    public CompileTimeContext() {
        this.templates = new Stack();
        this.localVariables = new LocalVariableMap();
        this.iteratorMap = new IteratorMap();
        assert (emptyTemplate != null);
        assert (CompileTimeContext.emptyTemplate.type == Template.TemplateType.OBJECT);
        this.objectTemplate = emptyTemplate;
    }

    @Override
    public Template getObjectTemplate() {
        return this.objectTemplate;
    }

    @Override
    public HashResource getRoot() {
        return null;
    }

    @Override
    public HashResource restoreRelativeRoot(HashResource previousValue) {
        return null;
    }

    @Override
    public HashResource createRelativeRoot() {
        return null;
    }

    @Override
    public Set<SourceFile> getDependencies() {
        return null;
    }

    @Override
    public Set<String> getObjectDependencies() {
        return null;
    }

    @Override
    public void turnOffObjectDependencyChecking() {
    }

    @Override
    public Template localLoad(String name2) {
        return null;
    }

    @Override
    public Template localAndGlobalLoad(String name2, boolean lookupOnly) {
        return null;
    }

    @Override
    public Template globalLoad(String name2) {
        return this.globalLoad(name2, false);
    }

    @Override
    public Template globalLoad(String name2, boolean lookupOnly) {
        return null;
    }

    @Override
    public SourceFile lookupFile(String name2) {
        return null;
    }

    @Override
    public LocalVariableMap createLocalVariableMap(ListResource argv) {
        LocalVariableMap oldMap = this.localVariables;
        this.localVariables = new LocalVariableMap(argv);
        return oldMap;
    }

    @Override
    public void restoreLocalVariableMap(LocalVariableMap localVariableHolder) {
        this.localVariables = localVariableHolder;
    }

    @Override
    public IteratorMap createIteratorMap() {
        IteratorMap oldIteratorMap = this.iteratorMap;
        this.iteratorMap = new IteratorMap();
        return oldIteratorMap;
    }

    @Override
    public void restoreIteratorMap(IteratorMap iteratorMap) {
        this.iteratorMap = iteratorMap;
    }

    @Override
    public void setObjectAndLoadpath() {
        StringProperty sname = StringProperty.getInstance(this.objectTemplate.name);
        this.setGlobalVariable("OBJECT", sname, true);
        this.setGlobalVariable("LOADPATH", new ListResource(), false);
    }

    @Override
    public String getObjectName() {
        return this.objectTemplate != null ? this.objectTemplate.name : "unknown";
    }

    @Override
    public FunctionDefinition getFunction(String name2) {
        return null;
    }

    @Override
    public void setFunction(String name2, Operation function, Template template2, SourceRange sourceRange) throws EvaluationException {
    }

    @Override
    public Map<Path, List<FullType>> getBindings() {
        return new HashMap<Path, List<FullType>>();
    }

    @Override
    public void setBinding(Path path2, FullType fullType, Template template2, SourceRange sourceRange) {
    }

    @Override
    public FullType getFullType(String name2) {
        return null;
    }

    @Override
    public void setFullType(String name2, FullType fullType, Template template2, SourceRange sourceRange) throws EvaluationException {
    }

    @Override
    public void setGlobalVariable(String name2, Element value) {
    }

    @Override
    public void setGlobalVariable(String name2, GlobalVariable variable) {
    }

    @Override
    public GlobalVariable replaceGlobalVariable(String name2, Element value, boolean finalFlag) {
        return null;
    }

    @Override
    public void setGlobalVariable(String name2, Element value, boolean finalFlag) {
    }

    @Override
    public void setIterator(Resource resource2, Resource.Iterator iterator) {
        this.iteratorMap.put(resource2, iterator);
    }

    @Override
    public Resource.Iterator getIterator(Resource resource2) {
        return this.iteratorMap.get(resource2);
    }

    @Override
    public void removeGlobalVariable(String name2) {
    }

    @Override
    public Element getGlobalVariable(String name2) {
        return null;
    }

    @Override
    public GlobalVariable retrieveGlobalVariable(String name2) {
        return null;
    }

    @Override
    public void pushTemplate(Template template2, SourceRange sourceRange, Level logLevel, String logMessage) {
        SourceLocation location = new SourceLocation(this.currentTemplate, sourceRange);
        this.templates.push(location);
        this.currentTemplate = template2;
        callLogger.log(logLevel, "ENTER", new Object[]{logMessage, this.currentTemplate.name});
        if (this.templates.size() > this.getCallLimit()) {
            this.popTemplate(Level.INFO, logMessage);
            throw new EvaluationException("call depth limit (" + this.getCallLimit() + ") exceeded", sourceRange, this);
        }
    }

    @Override
    public void popTemplate(Level logLevel, String logMessage) {
        callLogger.log(logLevel, "EXIT", new Object[]{logMessage, this.currentTemplate.name});
        SourceLocation location = this.templates.pop();
        this.currentTemplate = location.template;
    }

    @Override
    public void printTraceback(SourceRange sourceRange) {
        System.err.println(this.getTraceback(sourceRange));
    }

    @Override
    public String getTraceback(SourceRange sourceRange) {
        SourceLocation[] locations = this.templates.toArray(new SourceLocation[this.templates.size()]);
        StringBuilder sb = new StringBuilder();
        sb.append(">>> call stack trace \n");
        sb.append(">>> ");
        sb.append(new SourceLocation(this.currentTemplate, sourceRange).toString());
        sb.append("\n");
        for (int i = locations.length - 1; i >= 0; --i) {
            sb.append(">>> ");
            sb.append(locations[i].toString());
            sb.append("\n");
        }
        sb.append(">>> ====================\n\n");
        return sb.toString();
    }

    @Override
    public void setCurrentTemplate(Template template2) {
        this.currentTemplate = template2;
    }

    @Override
    public Template getCurrentTemplate() {
        return this.currentTemplate;
    }

    @Override
    public Element getElement(Path path2) throws EvaluationException, ValidationException {
        return this.getElement(path2, true);
    }

    @Override
    public Element getElement(Path path2, boolean errorIfNotFound) throws EvaluationException {
        return null;
    }

    @Override
    public void putElement(Path path2, Element value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element executeDmlBlock(Operation dml) {
        boolean setTemplate;
        Element result = null;
        LocalVariableMap oldVariables = this.createLocalVariableMap(null);
        IteratorMap oldIterators = this.createIteratorMap();
        boolean bl = setTemplate = this.getGlobalVariable(TPL_VAR) == null;
        if (setTemplate) {
            Template current = this.getCurrentTemplate();
            if (current != null) {
                StringProperty tname = StringProperty.getInstance(current.name);
                this.setGlobalVariable(TPL_VAR, tname, true);
            } else {
                setTemplate = false;
            }
        }
        try {
            result = dml.execute(this);
        }
        catch (ReturnValueException rve) {
            result = rve.getElement();
        }
        finally {
            if (setTemplate) {
                this.removeGlobalVariable(TPL_VAR);
            }
            this.restoreLocalVariableMap(oldVariables);
            this.restoreIteratorMap(oldIterators);
        }
        return result;
    }

    @Override
    public boolean executeDmlValidationBlock(Operation dml, Element self) throws ValidationException {
        Element result = null;
        LocalVariableMap oldVariables = this.createLocalVariableMap(null);
        IteratorMap oldIterators = this.createIteratorMap();
        ReadOnlySelfHolder selfHolder = new ReadOnlySelfHolder(self);
        this.initializeSelfHolder(selfHolder);
        try {
            result = dml.execute(this);
        }
        catch (ReturnValueException rve) {
            result = rve.getElement();
        }
        catch (EvaluationException ee) {
            File objectFile = this.objectTemplate != null ? this.objectTemplate.source : null;
            ValidationException ve = ValidationException.create("MSG_VALIDATION_FAILED_BECAUSE_OF_EXCEPTION", new Object[0]);
            ve.setObjectTemplate(objectFile);
            ve.initCause(ee);
            throw ve;
        }
        finally {
            this.clearSelf();
            this.restoreLocalVariableMap(oldVariables);
            this.restoreIteratorMap(oldIterators);
        }
        try {
            BooleanProperty bresult = (BooleanProperty)result;
            return bresult.getValue();
        }
        catch (ClassCastException cce) {
            File objectFile = this.objectTemplate != null ? this.objectTemplate.source : null;
            ValidationException ve = ValidationException.create("MSG_INVALID_VALIDATION_FUNCTION_RETURN_TYPE", result.getTypeAsString());
            throw ve.setObjectTemplate(objectFile);
        }
    }

    @Override
    public Element getLocalVariable(String name2) {
        return this.localVariables.get(name2);
    }

    @Override
    public Element getVariable(String name2) {
        Element result = this.localVariables.get(name2);
        if (result == null) {
            result = this.getGlobalVariable(name2);
        }
        return result;
    }

    @Override
    public Element dereferenceVariable(String name2, boolean lookupOnly, Term[] terms) throws InvalidTermException {
        boolean duplicate = false;
        Element result = this.localVariables.get(name2);
        if (result == null) {
            duplicate = true;
            result = this.getGlobalVariable(name2);
        }
        if (result != null) {
            result = !(result instanceof Undef) ? result.rget(terms, 0, false, lookupOnly) : null;
        }
        if (duplicate && result != null) {
            result = result.duplicate();
        }
        return result;
    }

    @Override
    public void setLocalVariable(String name2, Element value) throws EvaluationException {
        assert (name2 != null);
        this.localVariables.put(name2, value);
    }

    @Override
    public void setLocalVariable(String name2, Term[] terms, Element value) throws EvaluationException {
        assert (name2 != null);
        if (terms == null || terms.length == 0) {
            this.setLocalVariable(name2, value);
        } else {
            Element var = this.getLocalVariable(name2);
            if (var != null && var.isProtected()) {
                var = var.writableCopy();
                this.setLocalVariable(name2, var);
            }
            if (var == null || var instanceof Undef) {
                Term term = terms[0];
                var = term.isKey() ? new HashResource() : new ListResource();
                this.setLocalVariable(name2, var);
            }
            assert (var != null);
            try {
                var.rput(terms, 0, value);
            }
            catch (InvalidTermException ite) {
                throw new EvaluationException(ite.formatVariableMessage(name2, terms));
            }
        }
    }

    @Override
    public int getCallLimit() {
        return 50;
    }

    @Override
    public int getIterationLimit() {
        return 1000;
    }

    @Override
    public boolean isFinal(Path p) {
        return false;
    }

    @Override
    public String getFinalReason(Path p) {
        return null;
    }

    @Override
    public void setFinal(Path p) {
    }

    @Override
    public boolean isCompileTimeContext() {
        return true;
    }

    @Override
    public void initializeSelfHolder(SelfHolder selfHolder) {
    }

    @Override
    public boolean isSelfFinal() {
        return false;
    }

    @Override
    public Element getSelf() {
        return null;
    }

    @Override
    public void clearSelf() {
    }

    @Override
    public SelfHolder saveSelf() {
        return null;
    }

    @Override
    public void restoreSelf(SelfHolder self) {
    }

    @Override
    public void resetSelf(Element newValue) {
    }

    @Override
    public void setRelativeLoadpaths(List<String> rpaths) {
    }

    @Override
    public List<String> getRelativeLoadpaths() {
        return null;
    }

    @Override
    public CompilerOptions.DeprecationWarnings getDeprecationWarnings() {
        return this.deprecationWarnings;
    }

    static {
        try {
            emptyTemplate = new Template("empty");
        }
        catch (SyntaxException se) {
            throw CompilerError.create("MSG_CANNOT_CREATE_EMPTY_TEMPLATE", new Object[0]);
        }
    }
}

