/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.tasks;

import java.io.File;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quattor.pan.Compiler;
import org.quattor.pan.CompilerLogging;
import org.quattor.pan.cache.Valid2Cache;
import org.quattor.pan.output.Formatter;
import org.quattor.pan.output.FormatterUtils;
import org.quattor.pan.tasks.FinalResult;
import org.quattor.pan.tasks.Task;
import org.quattor.pan.tasks.TaskResult;
import org.quattor.pan.tasks.Valid2Result;

public class WriteOutputTask
extends Task<TaskResult> {
    private static final Logger taskLogger = CompilerLogging.LoggingType.TASK.logger();

    public WriteOutputTask(Formatter formatter2, Compiler compiler, String objectName, File outputDirectory) {
        super(TaskResult.ResultType.XML, objectName, new CallImpl(formatter2, compiler, objectName, outputDirectory));
    }

    private static class CallImpl
    implements Callable<TaskResult> {
        private final Formatter formatter;
        private final Compiler compiler;
        private final String objectName;
        private final File outputDirectory;

        public CallImpl(Formatter formatter2, Compiler compiler, String objectName, File outputDirectory) {
            assert (formatter2 != null);
            this.formatter = formatter2;
            this.compiler = compiler;
            this.objectName = objectName;
            this.outputDirectory = outputDirectory;
        }

        @Override
        public TaskResult call() throws Exception {
            Valid2Cache v2cache = this.compiler.getValid2Cache();
            Valid2Result result = (Valid2Result)v2cache.waitForResult(this.objectName);
            FinalResult finalResult = new FinalResult(this.compiler, result);
            taskLogger.log(Level.FINER, "START_XMLFILE", this.objectName);
            URI resultURI = this.formatter.getResultURI(result.objectName);
            URI absoluteURI = this.outputDirectory.toURI().resolve(resultURI);
            File absolutePath = new File(absoluteURI);
            FormatterUtils.createParentDirectories(absolutePath);
            this.formatter.write(finalResult, absoluteURI);
            FormatterUtils.setOutputTimestamp(absolutePath, result.timestamp);
            taskLogger.log(Level.FINER, "END_XMLFILE", this.objectName);
            return new TaskResult(TaskResult.ResultType.XML);
        }
    }
}

