/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.tasks;

import java.io.File;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quattor.pan.CompilerLogging;
import org.quattor.pan.parser.ASTTemplate;
import org.quattor.pan.parser.PanParserAnnotationUtils;
import org.quattor.pan.tasks.Task;
import org.quattor.pan.tasks.TaskResult;

public class WriteAnnotationTask
extends Task<TaskResult> {
    private static final Logger taskLogger = CompilerLogging.LoggingType.TASK.logger();

    public WriteAnnotationTask(File outputFile, ASTTemplate ast2) {
        super(TaskResult.ResultType.ANNOTATION, ast2.getIdentifier(), new CallImpl(outputFile, ast2));
    }

    private static class CallImpl
    implements Callable<TaskResult> {
        private final File outputFile;
        private final String objectName;
        private final ASTTemplate ast;

        public CallImpl(File outputFile, ASTTemplate ast2) {
            this.outputFile = outputFile;
            this.objectName = ast2.getIdentifier();
            this.ast = ast2;
        }

        @Override
        public TaskResult call() throws Exception {
            taskLogger.log(Level.FINER, "START_ANNOTATION_FILE", this.objectName);
            if (this.outputFile != null) {
                PanParserAnnotationUtils.printXML(this.outputFile, this.ast);
            }
            taskLogger.log(Level.FINER, "END_ANNOTATION_FILE", this.objectName);
            return new TaskResult(TaskResult.ResultType.ANNOTATION);
        }
    }
}

