/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.tasks;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quattor.pan.Compiler;
import org.quattor.pan.CompilerLogging;
import org.quattor.pan.cache.BuildCache;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ElementUtils;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.tasks.BuildResult;
import org.quattor.pan.tasks.Task;
import org.quattor.pan.tasks.TaskResult;
import org.quattor.pan.tasks.Valid1Result;
import org.quattor.pan.template.Context;
import org.quattor.pan.type.FullType;
import org.quattor.pan.utils.Path;

public class Valid1Task
extends Task<Valid1Result> {
    private static final Logger taskLogger = CompilerLogging.LoggingType.TASK.logger();

    public Valid1Task(Compiler compiler, String objectName) {
        super(TaskResult.ResultType.VALID1, objectName, new CallImpl(compiler, objectName));
    }

    private static class CallImpl
    implements Callable<Valid1Result> {
        private final Compiler compiler;
        private final String objectName;

        public CallImpl(Compiler compiler, String objectName) {
            this.compiler = compiler;
            this.objectName = objectName;
        }

        @Override
        public Valid1Result call() throws Exception {
            BuildCache bcache = this.compiler.getBuildCache();
            BuildResult result = (BuildResult)bcache.waitForResult(this.objectName);
            Context context = result.getObjectContext();
            taskLogger.log(Level.FINER, "START_VALID1", this.objectName);
            this.validate(this.objectName, context);
            taskLogger.log(Level.FINER, "END_VALID1", this.objectName);
            return new Valid1Result(context.getRoot().protect(), context);
        }

        private void validate(String objectName, Context context) throws ValidationException {
            File objectFile = context.getObjectTemplate() != null ? context.getObjectTemplate().source : null;
            String rpath = ElementUtils.locateUndefinedElement(context.getRoot());
            if (rpath != null) {
                ValidationException ve = ValidationException.create("MSG_VALUE_AT_PATH_UNDEFINED", rpath);
                throw ve.setObjectTemplate(objectFile);
            }
            Map<Path, List<FullType>> bindings = context.getBindings();
            for (Map.Entry<Path, List<FullType>> entry : bindings.entrySet()) {
                Path path2 = entry.getKey();
                Element self = null;
                try {
                    self = context.getElement(path2);
                }
                catch (EvaluationException evaluationException) {
                    // empty catch block
                }
                for (FullType type2 : entry.getValue()) {
                    try {
                        type2.validate(context, self);
                    }
                    catch (ValidationException ve) {
                        throw ve.setPathTypeAndObject(path2, type2, objectFile);
                    }
                }
            }
        }
    }
}

