/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.tasks;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.quattor.pan.Compiler;
import org.quattor.pan.cache.Valid2Cache;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.repository.SourceFile;
import org.quattor.pan.tasks.TaskResult;
import org.quattor.pan.tasks.Valid2Result;

public class FinalResult
extends TaskResult {
    private final Element root;
    public final long timestamp;
    public final String objectName;
    Set<SourceFile> dependencies;

    public FinalResult(Compiler compiler, Valid2Result result) {
        super(TaskResult.ResultType.VALID2);
        this.root = result.getRoot();
        this.timestamp = result.timestamp;
        this.objectName = result.objectName;
        this.dependencies = this.resolveAllDependencies(compiler);
    }

    public Element getRoot() {
        return this.root;
    }

    public Set<SourceFile> getDependencies() {
        return this.dependencies;
    }

    public Set<SourceFile> resolveAllDependencies(Compiler compiler) {
        TreeSet<SourceFile> allDependencies = new TreeSet<SourceFile>();
        if (compiler != null) {
            Valid2Cache v2cache = compiler.getValid2Cache();
            LinkedList<String> processed = new LinkedList<String>();
            Stack<String> unprocessed = new Stack<String>();
            unprocessed.push(this.objectName);
            while (!unprocessed.empty()) {
                String objectToProcess = (String)unprocessed.pop();
                if (processed.contains(objectToProcess)) continue;
                processed.add(objectToProcess);
                Valid2Result result = (Valid2Result)v2cache.waitForResult(objectToProcess);
                allDependencies.addAll(result.getDependencies());
                unprocessed.addAll(result.getObjectDependencies());
            }
        }
        return Collections.unmodifiableSet(allDependencies);
    }
}

