/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quattor.pan.CompilerLogging;
import org.quattor.pan.CompilerOptions;
import org.quattor.pan.cache.CompileCache;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.exceptions.SystemException;
import org.quattor.pan.parser.ASTTemplate;
import org.quattor.pan.parser.PanParser;
import org.quattor.pan.parser.PanParserAstUtils;
import org.quattor.pan.parser.ParseException;
import org.quattor.pan.tasks.CompileResult;
import org.quattor.pan.tasks.Task;
import org.quattor.pan.tasks.TaskResult;
import org.quattor.pan.template.Template;

public class CompileTask
extends Task<CompileResult> {
    private static final Logger taskLogger = CompilerLogging.LoggingType.TASK.logger();

    public CompileTask(String tplfile, CompileCache.PostCompileProcessor postCompileProcessor, CompilerOptions compilerOptions) {
        super(TaskResult.ResultType.COMPILED, tplfile, new CallImpl(tplfile, postCompileProcessor, compilerOptions));
    }

    public static class CallImpl
    implements Callable<CompileResult> {
        private final File tplfile;
        private final CompileCache.PostCompileProcessor postCompileProcessor;
        private final CompilerOptions compilerOptions;

        public CallImpl(String tplpath, CompileCache.PostCompileProcessor postCompileProcessor, CompilerOptions compilerOptions) {
            File tplfile = new File(tplpath);
            assert (tplfile != null);
            assert (tplfile.isAbsolute());
            assert (tplfile.getName().endsWith(".pan"));
            this.tplfile = tplfile;
            this.postCompileProcessor = postCompileProcessor;
            this.compilerOptions = compilerOptions;
        }

        @Override
        public CompileResult call() throws Exception {
            try {
                taskLogger.log(Level.FINER, "START_COMPILE", this.tplfile.getAbsolutePath());
                ASTTemplate ast2 = CallImpl.compile(this.tplfile, this.compilerOptions);
                Template template2 = PanParserAstUtils.convertAstToTemplate(this.tplfile, ast2);
                assert (template2 != null);
                this.postCompileProcessor.process(ast2, template2);
                CompileResult result = new CompileResult(template2);
                taskLogger.log(Level.FINER, "END_COMPILE", this.tplfile.getAbsolutePath());
                return result;
            }
            catch (SyntaxException se) {
                throw se.addExceptionInfo(null, this.tplfile);
            }
        }

        public static ASTTemplate compile(File tplfile, CompilerOptions compilerOptions) throws Exception {
            ASTTemplate ast2 = null;
            if (!tplfile.canRead()) {
                throw new SystemException("template file cannot be read", tplfile);
            }
            Reader reader2 = null;
            try {
                reader2 = new InputStreamReader((InputStream)new FileInputStream(tplfile), "UTF-8");
                PanParser parser = new PanParser(reader2);
                parser.setFile(tplfile);
                parser.setCompilerOptions(compilerOptions);
                ast2 = parser.template();
            }
            catch (ParseException pe) {
                pe.file = tplfile;
                throw pe;
            }
            catch (IOException ioe) {
                SystemException se = new SystemException("IO error", tplfile);
                se.initCause(ioe);
                throw se;
            }
            catch (EvaluationException ee) {
                throw ee.addExceptionInfo(null, tplfile, null);
            }
            catch (Exception e2) {
                SystemException se = new SystemException("unexpected system exception", tplfile);
                se.initCause(e2);
                throw se;
            }
            finally {
                if (reader2 != null) {
                    try {
                        reader2.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            assert (ast2 != null);
            return ast2;
        }
    }
}

