/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.tasks;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quattor.pan.Compiler;
import org.quattor.pan.CompilerLogging;
import org.quattor.pan.cache.CompileCache;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.repository.SourceFile;
import org.quattor.pan.tasks.BuildResult;
import org.quattor.pan.tasks.CompileResult;
import org.quattor.pan.tasks.Task;
import org.quattor.pan.tasks.TaskResult;
import org.quattor.pan.template.BuildContext;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.template.Template;
import org.quattor.pan.type.FullType;
import org.quattor.pan.utils.Path;

public class BuildTask
extends Task<BuildResult> {
    private static final Logger callLogger = CompilerLogging.LoggingType.CALL.logger();
    private static final Logger taskLogger = CompilerLogging.LoggingType.TASK.logger();

    public BuildTask(Compiler compiler, String objectName) {
        super(TaskResult.ResultType.BUILD, objectName, new CallImpl(compiler, objectName));
    }

    private static class CallImpl
    implements Callable<BuildResult> {
        private final Compiler compiler;
        private final String objectName;

        public CallImpl(Compiler compiler, String objectName) {
            this.compiler = compiler;
            this.objectName = objectName;
        }

        @Override
        public BuildResult call() throws Exception {
            File tplFile = null;
            SourceFile source2 = this.compiler.getSourceRepository().retrievePanSource(this.objectName);
            if (source2.getType().isAbsent()) {
                throw EvaluationException.create((SourceRange)null, (Context)null, "MSG_CANNOT_LOCATE_OBJECT_TEMPLATE", this.objectName);
            }
            tplFile = source2.getPath();
            CompileCache ccache = this.compiler.getCompileCache();
            CompileResult cresult = (CompileResult)ccache.waitForResult(tplFile.getAbsolutePath());
            Template template2 = cresult.template;
            template2.templateNameVerification(this.objectName);
            taskLogger.log(Level.FINER, "START_BUILD", this.objectName);
            callLogger.log(Level.INFO, "ENTER", new Object[]{"OBJECT", this.objectName});
            BuildContext context = new BuildContext(this.compiler, template2);
            this.execute(context, this.objectName);
            this.setDefaults(context, this.objectName);
            context.turnOffObjectDependencyChecking();
            callLogger.log(Level.INFO, "EXIT", new Object[]{"OBJECT", this.objectName});
            taskLogger.log(Level.FINER, "END_BUILD", this.objectName);
            return new BuildResult(context.getRoot().protect(), context);
        }

        private void execute(Context context, String objectName) {
            taskLogger.log(Level.FINER, "START_EXECUTE", objectName);
            try {
                context.setObjectAndLoadpath();
                context.setCurrentTemplate(context.getObjectTemplate());
                context.getObjectTemplate().execute(context, true);
            }
            catch (EvaluationException ee) {
                throw ee.addExceptionInfo(null, context.getCurrentTemplate().source, null);
            }
            taskLogger.log(Level.FINER, "END_EXECUTE", objectName);
        }

        private void setDefaults(Context context, String objectName) {
            taskLogger.log(Level.FINER, "START_DEFAULTS", objectName);
            Map<Path, List<FullType>> bindings = context.getBindings();
            for (Map.Entry<Path, List<FullType>> entry : bindings.entrySet()) {
                Path path2 = entry.getKey();
                Element self = null;
                try {
                    self = context.getElement(path2, false);
                }
                catch (EvaluationException consumed) {
                    break;
                }
                if (self == null || self instanceof Undef) {
                    for (FullType type2 : entry.getValue()) {
                        Element defaultValue = type2.findDefault(context);
                        if (defaultValue == null) continue;
                        self = defaultValue;
                        context.putElement(path2, defaultValue);
                        break;
                    }
                }
                if (self == null || self instanceof Undef) continue;
                for (FullType type2 : entry.getValue()) {
                    Element replacement = type2.setDefaults(context, self);
                    if (replacement == null) continue;
                    self = replacement;
                    context.putElement(path2, replacement);
                }
            }
            taskLogger.log(Level.FINER, "END_DEFAULTS", objectName);
        }
    }
}

