/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import java.util.LinkedList;
import java.util.List;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.InvalidTermException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.statement.ComputedLoadpathStatement;
import org.quattor.pan.statement.ComputedVariableStatement;
import org.quattor.pan.statement.ConstantLoadpathStatement;
import org.quattor.pan.statement.ConstantVariableStatement;
import org.quattor.pan.statement.Statement;
import org.quattor.pan.template.CompileTimeContext;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.TermFactory;

public abstract class VariableStatement
extends Statement {
    private static final String[] automaticVariables = new String[]{"OBJECT", "SELF", "ARGC", "ARGV", "FUNCTION", "TEMPLATE"};
    protected final String name;
    protected final boolean conditional;
    protected final boolean modifiable;

    protected VariableStatement(SourceRange sourceRange, String name2, boolean conditional, boolean modifiable) throws SyntaxException {
        super(sourceRange);
        assert (name2 != null);
        this.validName(name2);
        this.name = name2;
        this.conditional = conditional;
        this.modifiable = modifiable;
    }

    public static VariableStatement getInstance(SourceRange sourceRange, String name2, Operation dml, boolean conditional, boolean modifiable) throws SyntaxException {
        VariableStatement result = null;
        Element value = null;
        try {
            CompileTimeContext context = new CompileTimeContext();
            value = context.executeDmlBlock(dml);
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        result = value != null ? ("LOADPATH".equals(name2) ? new ConstantLoadpathStatement(sourceRange, value, conditional, modifiable) : new ConstantVariableStatement(sourceRange, name2, value, conditional, modifiable)) : ("LOADPATH".equals(name2) ? new ComputedLoadpathStatement(sourceRange, dml, conditional, modifiable) : new ComputedVariableStatement(sourceRange, name2, dml, conditional, modifiable));
        return result;
    }

    private void validName(String name2) throws SyntaxException {
        for (String varName : automaticVariables) {
            if (!varName.equals(name2)) continue;
            throw SyntaxException.create(this.getSourceRange(), "MSG_AUTO_VAR_CANNOT_BE_SET", varName);
        }
    }

    public static List<String> convertLoadpathVariable(Element element) {
        LinkedList<String> filelist = new LinkedList<String>();
        filelist.add("");
        if (element == null) {
            return filelist;
        }
        if (!(element instanceof ListResource)) {
            throw new EvaluationException("LOADPATH variable must be a list");
        }
        ListResource loadpath = (ListResource)element;
        for (int i = 0; i < loadpath.size(); ++i) {
            try {
                String sfile;
                Element child = loadpath.get(TermFactory.create(i));
                if (child instanceof StringProperty) {
                    sfile = ((StringProperty)child).getValue();
                    if (sfile.startsWith("/")) {
                        throw new EvaluationException("LOADPATH can only contain relative paths");
                    }
                } else {
                    throw new EvaluationException("LOADPATH contains non-string value");
                }
                filelist.add(sfile);
                continue;
            }
            catch (InvalidTermException ite) {
                throw CompilerError.create("MSG_INVALID_KEY_OR_INDEX", new Object[0]);
            }
        }
        return filelist;
    }
}

