/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import org.quattor.pan.dml.data.Element;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.statement.BindStatement;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.type.FullType;
import org.quattor.pan.utils.Path;

public class StaticBindStatement
extends BindStatement {
    private final Path path;
    private final FullType fullType;

    public StaticBindStatement(SourceRange sourceRange, Path path2, FullType fullType) throws SyntaxException {
        super(sourceRange);
        if (!path2.isAbsolute()) {
            throw SyntaxException.create(sourceRange, "MSG_ABSOLUTE_PATH_ONLY_FOR_BIND", path2);
        }
        this.path = path2;
        this.fullType = fullType;
    }

    @Override
    public Element execute(Context context) {
        assert (context != null);
        context.setBinding(this.path, this.fullType, context.getCurrentTemplate(), this.getSourceRange());
        return null;
    }

    public String toString() {
        return "BIND: " + this.path + ", " + this.fullType;
    }
}

