/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import clojure.lang.AFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public abstract class Statement
extends AFn
implements Operation {
    private final SourceRange sourceRange;
    private final AtomicReference<IPersistentMap> metadataRef = new AtomicReference();

    public Statement(SourceRange sourceRange) {
        assert (sourceRange != null);
        this.sourceRange = sourceRange;
    }

    @Override
    public IPersistentMap meta() {
        return this.metadataRef.get();
    }

    @Override
    public IObj withMeta(IPersistentMap iPersistentMap) {
        this.metadataRef.set(iPersistentMap);
        return this;
    }

    @Override
    public Object invoke(Object o1) {
        try {
            return this.execute((Context)o1);
        }
        catch (ClassCastException ex) {
            throw CompilerError.create("MSG_OPERATION_WITHOUT_CONTEXT", new Object[0]);
        }
    }

    public SourceRange getSourceRange() {
        return this.sourceRange;
    }

    @Override
    public abstract Element execute(Context var1) throws EvaluationException;

    @Override
    public void checkRestrictedContext() throws SyntaxException {
    }

    @Override
    public void checkInvalidSelfContext() throws SyntaxException {
    }
}

