/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.statement.Statement;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public class FunctionStatement
extends Statement {
    private final String name;
    private final Operation function;

    public FunctionStatement(SourceRange sourceRange, String name2, Operation function) {
        super(sourceRange);
        assert (name2 != null);
        this.name = name2;
        this.function = function;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Element execute(Context context) {
        try {
            context.setFunction(this.name, this.function, context.getCurrentTemplate(), this.getSourceRange());
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.getSourceRange(), context);
        }
        return null;
    }

    public String toString() {
        return "FUNCTION: " + this.name + ", " + this.function;
    }
}

