/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.statement.BindStatement;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.type.FullType;
import org.quattor.pan.utils.Path;

public class DynamicBindStatement
extends BindStatement {
    private final String pathname;
    private final FullType fullType;

    public DynamicBindStatement(SourceRange sourceRange, String pathname, FullType fullType) throws SyntaxException {
        super(sourceRange);
        assert (pathname != null);
        assert (fullType != null);
        this.pathname = pathname;
        this.fullType = fullType;
    }

    @Override
    public Element execute(Context context) {
        assert (context != null);
        String resolvedPath = null;
        try {
            ContextResolver resolver = new ContextResolver(context);
            StrSubstitutor sub = new StrSubstitutor(resolver);
            resolvedPath = sub.replace(this.pathname);
        }
        catch (Exception e2) {
            throw new EvaluationException(e2.getMessage(), this.getSourceRange());
        }
        Path path2 = DynamicBindStatement.createPathFromIdentifier(this.getSourceRange(), resolvedPath);
        context.setBinding(path2, this.fullType, context.getCurrentTemplate(), this.getSourceRange());
        return null;
    }

    public String toString() {
        return "BIND: " + this.pathname + ", " + this.fullType;
    }

    private static Path createPathFromIdentifier(SourceRange sourceRange, String pathname) {
        try {
            assert (pathname != null);
            return new Path(pathname);
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(sourceRange, null);
        }
        catch (SyntaxException se) {
            throw new EvaluationException(se.getSimpleMessage(), sourceRange);
        }
    }

    private class ContextResolver
    extends StrLookup<String> {
        private final Context context;

        public ContextResolver(Context context) {
            this.context = context;
        }

        @Override
        public String lookup(String name2) {
            try {
                return this.context.getGlobalVariable(name2).toString();
            }
            catch (NullPointerException e2) {
                throw EvaluationException.create(DynamicBindStatement.this.getSourceRange(), this.context, "MSG_SUBSTITUTE_VARIABLE_UNDEFINED", name2);
            }
        }
    }
}

