/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import org.quattor.pan.dml.data.Element;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.statement.AssignmentStatement;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.Path;

public class DeleteAssignmentStatement
extends AssignmentStatement {
    protected DeleteAssignmentStatement(SourceRange sourceRange, Path path2, boolean conditional, boolean modifiable) throws SyntaxException {
        super(sourceRange, path2, conditional, modifiable);
    }

    @Override
    public Element execute(Context context) throws EvaluationException {
        assert (context != null);
        try {
            if (!this.conditional) {
                if (this.path.isAbsolute() && context.isFinal(this.path)) {
                    throw new EvaluationException(context.getFinalReason(this.path), this.getSourceRange());
                }
                context.putElement(this.path, null);
            }
            if (this.path.isAbsolute() && !this.modifiable) {
                context.setFinal(this.path);
            }
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.getSourceRange(), context);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.modifiable) {
            sb.append("final ");
        }
        sb.append(this.path.toString());
        if (this.conditional) {
            sb.append(" ?= ");
        } else {
            sb.append(" = ");
        }
        sb.append("null;");
        return sb.toString();
    }
}

