/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.statement.VariableStatement;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.template.VariableSelfHolder;
import org.quattor.pan.utils.GlobalVariable;

public class ComputedVariableStatement
extends VariableStatement {
    protected final Operation dml;

    protected ComputedVariableStatement(SourceRange sourceRange, String name2, Operation dml, boolean conditional, boolean modifiable) throws SyntaxException {
        super(sourceRange, name2, conditional, modifiable);
        this.dml = dml;
    }

    @Override
    public Element execute(Context context) {
        try {
            GlobalVariable variable = context.retrieveGlobalVariable(this.name);
            VariableSelfHolder selfHolder = new VariableSelfHolder(variable);
            context.initializeSelfHolder(selfHolder);
            Element currentValue = variable.getValue();
            assert (currentValue != null);
            if (!this.conditional || currentValue instanceof Undef || currentValue instanceof Null) {
                Element result = context.executeDmlBlock(this.dml);
                variable.setValue(result);
                variable.setFinalFlag(!this.modifiable);
            } else if (this.conditional && !this.modifiable) {
                variable.setFinalFlag(!this.modifiable);
            }
            context.clearSelf();
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.getSourceRange(), context);
        }
        return null;
    }

    public String toString() {
        return "VARIABLE: " + this.name + ", " + this.conditional + ", " + this.modifiable + ", " + this.dml;
    }
}

