/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Null;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.statement.IncludeStatement;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.InvalidSelfHolder;
import org.quattor.pan.template.SourceRange;

public class ComputedIncludeStatement
extends IncludeStatement {
    private final Operation dml;

    public ComputedIncludeStatement(SourceRange sourceRange, Operation dml) {
        super(sourceRange);
        assert (dml != null);
        this.dml = dml;
    }

    @Override
    public Element execute(Context context) {
        InvalidSelfHolder selfHolder = new InvalidSelfHolder();
        context.initializeSelfHolder(selfHolder);
        Element result = context.executeDmlBlock(this.dml);
        context.clearSelf();
        if (result instanceof Null || result instanceof Undef) {
            return null;
        }
        String name2 = null;
        try {
            name2 = ((StringProperty)result).getValue();
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("DML block for computed include statement didn't evaluate to undef, null, or a string", null);
        }
        if (!ComputedIncludeStatement.validIdentifier(name2)) {
            throw new EvaluationException("invalid identifier for include: " + name2, this.getSourceRange());
        }
        this.executeWithNamedTemplate(context, name2);
        return null;
    }

    public String toString() {
        return "COMPUTED INCLUDE: " + this.dml;
    }
}

