/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.statement.DynamicBindStatement;
import org.quattor.pan.statement.Statement;
import org.quattor.pan.statement.StaticBindStatement;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.type.FullType;
import org.quattor.pan.utils.Path;

public abstract class BindStatement
extends Statement {
    protected BindStatement(SourceRange sourceRange) {
        super(sourceRange);
    }

    public static BindStatement getInstance(SourceRange sourceRange, String pathname, FullType fullType) throws SyntaxException {
        assert (pathname != null);
        assert (fullType != null);
        if (BindStatement.isStaticPath(pathname)) {
            Path path2 = BindStatement.createPathFromIdentifier(sourceRange, pathname);
            if (!path2.isAbsolute()) {
                throw SyntaxException.create(sourceRange, "MSG_ABSOLUTE_PATH_ONLY_FOR_BIND", path2);
            }
            return new StaticBindStatement(sourceRange, path2, fullType);
        }
        return new DynamicBindStatement(sourceRange, pathname, fullType);
    }

    private static Path createPathFromIdentifier(SourceRange sourceRange, String pathname) throws SyntaxException {
        try {
            assert (pathname != null);
            return new Path(pathname);
        }
        catch (EvaluationException ee) {
            throw SyntaxException.create(sourceRange, ee);
        }
        catch (SyntaxException se) {
            throw se.addExceptionInfo(sourceRange, null);
        }
    }

    private static boolean isStaticPath(String pathname) {
        NoOpResolver noOpResolver = new NoOpResolver();
        StrSubstitutor sub = new StrSubstitutor(noOpResolver);
        sub.replace(pathname);
        return !noOpResolver.lookupOccurred();
    }

    private static class NoOpResolver
    extends StrLookup<String> {
        private boolean lookupOccurred = false;

        private NoOpResolver() {
        }

        @Override
        public String lookup(String variable) {
            this.lookupOccurred = true;
            return "";
        }

        public boolean lookupOccurred() {
            return this.lookupOccurred;
        }
    }
}

