/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.repository.SourceType;
import org.quattor.pan.template.Template;
import org.quattor.pan.utils.MessageUtils;

@Immutable
public class SourceFile
implements Comparable<SourceFile> {
    private final String name;
    private final SourceType type;
    private final File location;
    private final File path;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SourceFile(String name2, boolean isSource, File path2) throws IllegalArgumentException {
        this.name = name2;
        this.path = path2;
        if (isSource) {
            if (path2 == null) {
                this.type = SourceType.ABSENT_SOURCE;
            } else {
                String extension = this.getFileExtension(path2);
                if (".tpl".equals(extension)) {
                    this.type = SourceType.TPL;
                } else {
                    if (!".pan".equals(extension)) throw new IllegalArgumentException(MessageUtils.format("MSG_INVALID_TPL_NAME", name2));
                    this.type = SourceType.PAN;
                }
            }
        } else {
            this.type = path2 != null ? SourceType.TEXT : SourceType.ABSENT_TEXT;
        }
        this.validateFields(name2, this.type, path2);
        this.location = SourceFile.weakTemplateNameVerification(name2, this.type, path2);
    }

    public String getName() {
        return this.name;
    }

    public SourceType getType() {
        return this.type;
    }

    public File getLocation() {
        return this.location;
    }

    public File getPath() {
        return this.path;
    }

    public boolean isAbsent() {
        return this.type.isAbsent();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.path);
    }

    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream(), "UTF-8");
    }

    public int hashCode() {
        int hc = this.name.hashCode() ^ this.type.hashCode();
        if (this.path != null) {
            hc ^= this.path.hashCode();
        }
        return hc;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof SourceFile) {
            SourceFile s = (SourceFile)o;
            return this.compareTo(s) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(SourceFile o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int value = this.name.compareTo(o.name);
        if (value != 0) {
            return value;
        }
        value = this.type.compareTo(o.type);
        if (value != 0) {
            return value;
        }
        if (this.path != null && o.path != null) {
            value = this.path.compareTo(o.path);
            return value;
        }
        if (this.path == null && o.path == null) {
            return 0;
        }
        if (this.path == null) {
            return -1;
        }
        if (o.path == null) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        String uri = this.location != null ? this.location.toURI().toASCIIString() : "";
        return String.format("%s %s %s", new Object[]{this.name, this.type, uri});
    }

    private String getFileExtension(File path2) {
        String s;
        int index2;
        String extension = null;
        if (path2 != null && (index2 = (s = path2.toString()).lastIndexOf(46)) >= 0) {
            extension = s.substring(index2);
        }
        return extension;
    }

    private void validateFields(String name2, SourceType type2, File path2) throws CompilerError {
        if (name2 == null || type2 == null) {
            throw CompilerError.create("MSG_SRC_FILE_NAME_OR_TYPE_IS_NULL", new Object[0]);
        }
        if (type2.isAbsent() && path2 != null) {
            throw CompilerError.create("MSG_ABSENT_FILE_MUST_HAVE_NULL_PATH", new Object[0]);
        }
        if (path2 != null && !path2.isAbsolute()) {
            throw CompilerError.create("MSG_ABSOLUTE_PATH_REQ", new Object[0]);
        }
        if (!Template.isValidTemplateName(name2)) {
            throw new IllegalArgumentException(MessageUtils.format("MSG_INVALID_TPL_NAME", name2));
        }
    }

    private static File weakTemplateNameVerification(String name2, SourceType type2, File source2) throws IllegalArgumentException {
        File location = null;
        if (source2 != null) {
            StringBuilder sb = new StringBuilder("/");
            sb.append(name2);
            sb.append(type2.getExtension());
            String ending = sb.toString();
            String uri = source2.toURI().toString();
            if (!uri.endsWith(ending)) {
                throw new IllegalArgumentException(MessageUtils.format("MSG_MISNAMED_TPL", name2));
            }
            try {
                location = new File(new URI(uri.substring(0, uri.lastIndexOf(ending))));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return location;
    }
}

