/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.repository;

import net.jcip.annotations.Immutable;

@Immutable
public class Parameter {
    private final String name;
    private final String value;

    public Parameter(String key2, String value) {
        this.name = Parameter.validateName(key2);
        this.value = Parameter.validateValue(value);
    }

    public String getKey() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    private static String validateName(String name2) throws IllegalArgumentException {
        if (name2 == null) {
            throw new IllegalArgumentException("null is not a valid name");
        }
        if ("".equals(name2)) {
            throw new IllegalArgumentException("empty string is not a valid name");
        }
        return name2;
    }

    private static String validateValue(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("null is not a valid value");
        }
        return value;
    }
}

