/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.repository;

import java.io.File;
import java.util.List;
import org.quattor.pan.repository.FileSystemSourceRepository;
import org.quattor.pan.utils.FileUtils;

public class FileSystemSourceRepositoryImpl
extends FileSystemSourceRepository {
    private final List<File> includeDirectories;

    public FileSystemSourceRepositoryImpl(List<File> includeDirectories) {
        this.includeDirectories = this.validateAndCopyIncludeDirectories(includeDirectories);
    }

    @Override
    public File lookupText(String name2) {
        return this.lookupText(name2, emptyRelativePaths);
    }

    @Override
    public File lookupText(String name2, List<String> loadpath) {
        assert (name2 != null);
        assert (loadpath != null);
        assert (loadpath.size() > 0);
        String localName = FileUtils.localizeFilename(name2);
        for (File d : this.includeDirectories) {
            for (String rpath : loadpath) {
                File dir2 = new File(d, rpath);
                File sourceFile = new File(dir2, localName);
                if (!sourceFile.exists()) continue;
                return sourceFile;
            }
        }
        return null;
    }

    @Override
    public File lookupSource(String name2) {
        return this.lookupSource(name2, emptyRelativePaths);
    }

    @Override
    public File lookupSource(String name2, List<String> loadpath) {
        assert (name2 != null);
        assert (loadpath != null);
        assert (loadpath.size() > 0);
        String localName = FileUtils.localizeFilename(name2);
        for (File d : this.includeDirectories) {
            for (String rpath : loadpath) {
                File dir2 = new File(d, rpath);
                for (String suffix : sourceFileExtensions) {
                    File sourceFile = new File(dir2, localName + suffix);
                    if (!sourceFile.exists()) continue;
                    return sourceFile;
                }
            }
        }
        return null;
    }
}

