/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.repository;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.repository.FileSystemSourceRepositoryImpl;
import org.quattor.pan.repository.Parameter;
import org.quattor.pan.repository.ParameterList;
import org.quattor.pan.repository.SourceFile;
import org.quattor.pan.repository.SourceRepository;
import org.quattor.pan.repository.SourceType;

public abstract class FileSystemSourceRepository
implements SourceRepository {
    protected static final List<String> emptyRelativePaths;
    protected static final List<String> sourceFileExtensions;

    protected FileSystemSourceRepository() {
    }

    public static SourceRepository getInstance(ParameterList parameters) {
        if (parameters == null) {
            parameters = new ParameterList();
        }
        ArrayList<File> includeDirectories = new ArrayList<File>();
        for (Parameter parameter : parameters) {
            String name2 = parameter.getKey();
            if (!"includeDirectory".equals(name2)) continue;
            includeDirectories.add(new File(parameter.getValue()));
        }
        return new FileSystemSourceRepositoryImpl(includeDirectories);
    }

    public abstract File lookupSource(String var1);

    public abstract File lookupSource(String var1, List<String> var2);

    public abstract File lookupText(String var1);

    public abstract File lookupText(String var1, List<String> var2);

    @Override
    public SourceFile retrievePanSource(String name2) {
        File file2 = this.lookupSource(name2);
        return this.createPanSourceFile(name2, file2);
    }

    @Override
    public SourceFile retrievePanSource(String name2, List<String> loadpath) {
        File file2 = this.lookupSource(name2, loadpath);
        return this.createPanSourceFile(name2, file2);
    }

    @Override
    public SourceFile retrieveTxtSource(String name2) {
        File file2 = this.lookupText(name2);
        return this.createTxtSourceFile(name2, file2);
    }

    @Override
    public SourceFile retrieveTxtSource(String name2, List<String> loadpath) {
        File file2 = this.lookupText(name2, loadpath);
        return this.createTxtSourceFile(name2, file2);
    }

    private SourceFile createPanSourceFile(String name2, File file2) {
        return new SourceFile(name2, true, file2);
    }

    private SourceFile createTxtSourceFile(String name2, File file2) {
        return new SourceFile(name2, false, file2);
    }

    protected List<File> validateAndCopyIncludeDirectories(List<File> includeDirectories) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (includeDirectories != null && includeDirectories.size() != 0) {
            for (File d : includeDirectories) {
                if (!d.isAbsolute()) {
                    throw EvaluationException.create("MSG_NON_ABSOLUTE_PATH_IN_INCLUDE_DIRS", d.toString());
                }
                if (d.isDirectory()) continue;
                throw EvaluationException.create("MSG_NON_DIRECTORY_IN_INCLUDE_DIRS", d.toString());
            }
            dirs.addAll(includeDirectories);
        } else {
            dirs.add(new File(System.getProperty("user.dir")));
        }
        dirs.trimToSize();
        return Collections.unmodifiableList(dirs);
    }

    static {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("");
        list.trimToSize();
        emptyRelativePaths = list;
        ArrayList<String> extensions = new ArrayList<String>();
        for (SourceType type2 : SourceType.values()) {
            if (!type2.isSource()) continue;
            extensions.add(type2.getExtension());
        }
        extensions.trimToSize();
        sourceFileExtensions = Collections.unmodifiableList(extensions);
    }
}

