/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.parser;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.quattor.pan.parser.Node;
import org.quattor.pan.parser.PanParser;
import org.quattor.pan.parser.PanParserTreeConstants;
import org.quattor.pan.parser.Token;
import org.quattor.pan.template.SourceRange;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected PanParser parser;
    private SourceRange sourceRange = null;
    protected List<Token> specialTokens = new LinkedList<Token>();

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(PanParser p, int i) {
        this(i);
        this.parser = p;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return PanParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    public void setSourceRange(SourceRange sourceRange) {
        this.sourceRange = sourceRange;
    }

    public SourceRange getSourceRange() {
        return this.sourceRange;
    }

    public int getId() {
        return this.id;
    }

    public Object getSubtype() {
        return null;
    }

    public void addSpecialToken(Token specialToken) {
        this.specialTokens.add(specialToken);
    }

    public List<Token> getSpecialTokens() {
        return Collections.unmodifiableList(this.specialTokens);
    }
}

