/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.parser;

import java.util.List;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.parser.ASTOperation;
import org.quattor.pan.parser.ASTTemplate;
import org.quattor.pan.parser.ParseException;
import org.quattor.pan.parser.SimpleNode;
import org.quattor.pan.parser.Token;
import org.quattor.pan.template.SourceRange;

public class PanParserUtils {
    static void addSpecialTokens(SimpleNode node2, Token token) {
        Token currentToken = token;
        while (currentToken.specialToken != null) {
            node2.addSpecialToken(currentToken.specialToken);
            currentToken = currentToken.specialToken;
        }
    }

    static SourceRange sourceRangeFromTokens(Token start, Token end) {
        return new SourceRange(start.beginLine, start.beginColumn, end.endLine, end.endColumn);
    }

    static void replaceHeredocStrings(ASTTemplate tnode, List<StringProperty> strings) {
        if (strings.size() > 0) {
            PanParserUtils.processHeredocStrings(tnode, strings);
        }
    }

    private static void processHeredocStrings(SimpleNode node2, List<StringProperty> strings) {
        int count2 = node2.jjtGetNumChildren();
        if (count2 > 0) {
            for (int i = 0; i < count2; ++i) {
                ASTOperation astop;
                SimpleNode n = (SimpleNode)node2.jjtGetChild(i);
                if (n instanceof ASTOperation && (astop = (ASTOperation)n).getOperationType() == ASTOperation.OperationType.HEREDOC) {
                    Operation op = astop.getOperation();
                    if (op instanceof LongProperty) {
                        LongProperty lprop = (LongProperty)op;
                        int index2 = lprop.getValue().intValue();
                        StringProperty sprop = strings.get(index2);
                        astop.setOperationType(ASTOperation.OperationType.LITERAL);
                        astop.setOperation(sprop);
                    } else {
                        throw new RuntimeException("HEREDOC operation doesn't contain LongProperty");
                    }
                }
                PanParserUtils.processHeredocStrings(n, strings);
            }
        }
    }

    static void processSingleQuotedString(StringBuilder sb) {
        assert (sb.length() >= 2);
        assert (sb.charAt(0) == '\'' && sb.charAt(sb.length() - 1) == '\'');
        sb.deleteCharAt(sb.length() - 1);
        sb.deleteCharAt(0);
        int i = sb.indexOf("''", 0) + 1;
        while (i > 0) {
            sb.deleteCharAt(i);
            i = sb.indexOf("''", i) + 1;
        }
    }

    static void processDoubleQuotedString(StringBuilder sb, SourceRange sourceRange) throws ParseException {
        assert (sb.length() >= 2);
        assert (sb.charAt(0) == '\"' && sb.charAt(sb.length() - 1) == '\"');
        sb.deleteCharAt(sb.length() - 1);
        sb.deleteCharAt(0);
        int i = sb.indexOf("\\", 0);
        while (i >= 0) {
            if (i + 1 >= sb.length()) {
                ParseException pe = new ParseException("double-quoted string contains incomplete escape sequence");
                pe.sourceRange = sourceRange;
                throw pe;
            }
            switch (sb.charAt(i + 1)) {
                case 'n': {
                    sb.replace(i, i + 2, "\n");
                    break;
                }
                case 't': {
                    sb.replace(i, i + 2, "\t");
                    break;
                }
                case 'r': {
                    sb.replace(i, i + 2, "\r");
                    break;
                }
                case '\\': {
                    sb.replace(i, i + 2, "\\");
                    break;
                }
                case '\"': {
                    sb.replace(i, i + 2, "\"");
                    break;
                }
                case 'b': {
                    sb.replace(i, i + 2, "\b");
                    break;
                }
                case 'f': {
                    sb.replace(i, i + 2, "\f");
                    break;
                }
                case 'x': {
                    ParseException pe;
                    try {
                        int codepoint = Integer.parseInt(sb.substring(i + 2, i + 4), 16);
                        char[] chars2 = Character.toChars(codepoint);
                        sb.replace(i, i + 4, Character.toString(chars2[0]));
                        break;
                    }
                    catch (StringIndexOutOfBoundsException se) {
                        pe = new ParseException("double-quoted string contains incomplete hex escape sequence");
                        pe.sourceRange = sourceRange;
                        throw pe;
                    }
                    catch (NumberFormatException e2) {
                        pe = new ParseException("double-quoted string contains illegal hex replacement (" + sb.substring(i + 2, i + 4) + ")");
                        pe.sourceRange = sourceRange;
                        throw pe;
                    }
                }
                case '\n': 
                case '\r': {
                    int count2 = i + 2 < sb.length() && "\r\n".equals(sb.substring(i + 1, i + 3)) ? 3 : 2;
                    sb.delete(i, i + count2);
                    --i;
                    break;
                }
                default: {
                    ParseException pe = new ParseException("double-quoted string contains an illegal escape sequence (\\" + sb.charAt(i + 1) + ")");
                    pe.sourceRange = sourceRange;
                    throw pe;
                }
            }
            ++i;
            i = sb.indexOf("\\", i);
        }
    }
}

