/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.parser;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.quattor.pan.annotation.Annotation;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.exceptions.SystemException;
import org.quattor.pan.parser.ASTBaseTypeSpec;
import org.quattor.pan.parser.ASTFieldSpec;
import org.quattor.pan.parser.ASTOperation;
import org.quattor.pan.parser.ASTStatement;
import org.quattor.pan.parser.ASTTemplate;
import org.quattor.pan.parser.AnnotationToken;
import org.quattor.pan.parser.Node;
import org.quattor.pan.parser.SimpleNode;
import org.quattor.pan.parser.Token;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.XmlUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PanParserAnnotationUtils {
    public static final String PAN_ANNO_NS = "http://quattor.org/pan/annotations";

    public static void printXML(File outputFile, ASTTemplate ast2) {
        String templateName = ast2.getIdentifier();
        PanParserAnnotationUtils.createDirectories(outputFile);
        Writer writer2 = null;
        try {
            TransformerHandler handler = XmlUtils.getSaxTransformerHandler();
            writer2 = new PrintWriter(outputFile, "UTF-8");
            handler.setResult(new StreamResult(writer2));
            handler.startDocument();
            PanParserAnnotationUtils.writeASTNode(handler, ast2);
            handler.endDocument();
        }
        catch (SAXException se) {
            CompilerError error = CompilerError.create("MSG_UNEXPECTED_EXCEPTION_WHILE_WRITING_OUTPUT", new Object[0]);
            error.initCause(se);
            throw error;
        }
        catch (IOException e2) {
            String msg = MessageUtils.format("MSG_ERROR_WHILE_WRITING_OUTPUT", outputFile);
            SystemException exception = new SystemException(msg);
            throw exception;
        }
        finally {
            if (writer2 != null) {
                try {
                    writer2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void createDirectories(File outputFile) {
        File outputDir = outputFile.getParentFile();
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new SystemException("MSG_ERROR_CREATING_DIRECTORY", outputDir);
        }
    }

    private static void writeASTNode(TransformerHandler handler, Node ast2) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        String elementName = PanParserAnnotationUtils.getElementInfo(ast2, atts);
        if (elementName != null) {
            handler.startElement(PAN_ANNO_NS, null, elementName, atts);
            if (ast2 instanceof SimpleNode) {
                SimpleNode node2 = (SimpleNode)ast2;
                for (Token t : node2.getSpecialTokens()) {
                    PanParserAnnotationUtils.writeAnnotationToken(handler, t);
                }
            }
        }
        int nchild = ast2.jjtGetNumChildren();
        for (int i = 0; i < nchild; ++i) {
            PanParserAnnotationUtils.writeASTNode(handler, ast2.jjtGetChild(i));
        }
        if (elementName != null) {
            handler.endElement(PAN_ANNO_NS, null, elementName);
        }
    }

    private static String getElementInfo(Node ast2, AttributesImpl atts) {
        String elementName = null;
        if (ast2 instanceof ASTTemplate) {
            ASTTemplate tplNode = (ASTTemplate)ast2;
            elementName = "template";
            PanParserAnnotationUtils.addNameAttribute(atts, tplNode.getIdentifier());
            PanParserAnnotationUtils.addSourceRangeAttribute(atts, tplNode);
            PanParserAnnotationUtils.addAttribute(atts, "type", (Object)tplNode.getTemplateType());
        } else if (ast2 instanceof ASTStatement) {
            ASTStatement node2 = (ASTStatement)ast2;
            ASTStatement.StatementType type2 = node2.getStatementType();
            switch (type2) {
                case FUNCTION: 
                case VARIABLE: 
                case TYPE: {
                    elementName = node2.getStatementType().toString().toLowerCase();
                    PanParserAnnotationUtils.addNameAttribute(atts, node2.getIdentifier());
                    PanParserAnnotationUtils.addSourceRangeAttribute(atts, node2);
                    break;
                }
                default: {
                    elementName = null;
                    break;
                }
            }
        } else if (ast2 instanceof ASTFieldSpec) {
            ASTFieldSpec node3 = (ASTFieldSpec)ast2;
            if (node3.getInclude() == null) {
                elementName = "field";
                try {
                    PanParserAnnotationUtils.addNameAttribute(atts, node3.getKey());
                }
                catch (SyntaxException type2) {
                    // empty catch block
                }
                PanParserAnnotationUtils.addSourceRangeAttribute(atts, node3);
                PanParserAnnotationUtils.addAttribute(atts, "required", node3.isRequired());
            } else {
                elementName = "include";
                PanParserAnnotationUtils.addNameAttribute(atts, node3.getInclude());
                PanParserAnnotationUtils.addSourceRangeAttribute(atts, node3);
            }
        } else if (ast2 instanceof ASTBaseTypeSpec) {
            ASTBaseTypeSpec node4 = (ASTBaseTypeSpec)ast2;
            elementName = "basetype";
            PanParserAnnotationUtils.addNameAttribute(atts, node4.getIdentifier());
            PanParserAnnotationUtils.addSourceRangeAttribute(atts, node4);
            PanParserAnnotationUtils.addAttribute(atts, "extensible", node4.isExtensible());
            PanParserAnnotationUtils.addAttribute(atts, "range", node4.getRange());
        } else if (ast2 instanceof ASTOperation) {
            ASTOperation grandparent;
            ASTOperation parent;
            ASTOperation node5 = (ASTOperation)ast2;
            if (ast2.jjtGetParent() instanceof ASTOperation && (parent = (ASTOperation)ast2.jjtGetParent()).getOperationType() == ASTOperation.OperationType.DML && parent.jjtGetParent() instanceof ASTOperation && (grandparent = (ASTOperation)parent.jjtGetParent()).getOperationType() == ASTOperation.OperationType.DEFAULT && node5.getOperation() != null) {
                elementName = "default";
                PanParserAnnotationUtils.addSourceRangeAttribute(atts, node5);
                PanParserAnnotationUtils.addAttribute(atts, "text", node5.getOperation().toString());
            }
        }
        return elementName;
    }

    private static void writeAnnotationToken(TransformerHandler handler, Token t) throws SAXException {
        if (t instanceof AnnotationToken) {
            AnnotationToken token = (AnnotationToken)t;
            Annotation annotation = (Annotation)token.getValue();
            String name2 = annotation.getName();
            AttributesImpl atts = new AttributesImpl();
            if (!annotation.isAnonymous()) {
                handler.startElement(PAN_ANNO_NS, null, name2, atts);
            }
            for (Annotation.Entry entry : annotation.getEntries()) {
                String elementName = entry.getKey();
                char[] elementContents = entry.getValue().toCharArray();
                handler.startElement(PAN_ANNO_NS, null, elementName, atts);
                handler.characters(elementContents, 0, elementContents.length);
                handler.endElement(PAN_ANNO_NS, null, elementName);
            }
            if (!annotation.isAnonymous()) {
                handler.endElement(PAN_ANNO_NS, null, name2);
            }
        }
    }

    public static void addAttribute(AttributesImpl atts, String name2, Object value) {
        if (value != null) {
            atts.addAttribute(PAN_ANNO_NS, null, name2, "CDATA", value.toString());
        }
    }

    public static void addAttribute(AttributesImpl atts, String name2, boolean value) {
        Boolean bvalue = value;
        PanParserAnnotationUtils.addAttribute(atts, name2, bvalue);
    }

    public static void addNameAttribute(AttributesImpl atts, Object value) {
        PanParserAnnotationUtils.addAttribute(atts, "name", value);
    }

    public static void addSourceRangeAttribute(AttributesImpl atts, SimpleNode node2) {
        SourceRange sourceRange = node2.getSourceRange();
        PanParserAnnotationUtils.addAttribute(atts, "source-range", sourceRange);
    }
}

