/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.output;

import java.io.PrintWriter;
import java.nio.charset.Charset;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.output.AbstractFormatter;
import org.quattor.pan.output.XMLFormatterUtils;
import org.quattor.pan.tasks.FinalResult;
import org.quattor.pan.utils.Base64;
import org.quattor.pan.utils.XmlUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PanFormatter
extends AbstractFormatter {
    private static final PanFormatter instance = new PanFormatter();
    private static final String PAN_NS = "";

    private PanFormatter() {
        super("xml", "pan");
    }

    protected PanFormatter(String suffix, String key2) {
        super(suffix, key2);
    }

    public static PanFormatter getInstance() {
        return instance;
    }

    @Override
    protected void write(FinalResult result, PrintWriter ps) throws Exception {
        Element root2 = result.getRoot();
        String rootName = "profile";
        try {
            TransformerHandler handler = XmlUtils.getSaxTransformerHandler();
            handler.setResult(new StreamResult(ps));
            AttributesImpl atts = new AttributesImpl();
            handler.startDocument();
            atts.addAttribute(PAN_NS, null, "format", "CDATA", "pan");
            atts.addAttribute(PAN_NS, null, "name", "CDATA", rootName);
            this.writeChild(handler, atts, ps, root2);
            handler.endDocument();
        }
        catch (SAXException se) {
            CompilerError error = CompilerError.create("MSG_UNEXPECTED_EXCEPTION_WHILE_WRITING_OUTPUT", new Object[0]);
            error.initCause(se);
            throw error;
        }
    }

    private void writeChild(TransformerHandler handler, AttributesImpl atts, PrintWriter ps, Element node2) throws SAXException {
        String s;
        String tagName = node2.getTypeAsString();
        String stringContents = null;
        if (node2 instanceof StringProperty) {
            if (!"string".equals(tagName)) {
                atts.addAttribute(PAN_NS, null, "type", "CDATA", tagName);
                tagName = "string";
            }
            if (XMLFormatterUtils.isValidXMLString(s = ((Property)node2).toString())) {
                stringContents = s;
            } else {
                stringContents = Base64.encodeBytes(s.getBytes(Charset.forName("UTF-8")));
                atts.addAttribute(PAN_NS, null, "encoding", "CDATA", "base64");
            }
        }
        handler.startElement(PAN_NS, null, tagName, atts);
        atts.clear();
        if (node2 instanceof HashResource) {
            HashResource hash2 = (HashResource)node2;
            for (Resource.Entry entry : hash2) {
                String name2 = ((Property)entry.getKey()).toString();
                atts.addAttribute(PAN_NS, null, "name", "CDATA", name2);
                this.writeChild(handler, atts, ps, (Element)entry.getValue());
            }
        } else if (node2 instanceof ListResource) {
            ListResource list = (ListResource)node2;
            for (Resource.Entry entry : list) {
                this.writeChild(handler, atts, ps, (Element)entry.getValue());
            }
        } else if (node2 instanceof StringProperty) {
            handler.characters(stringContents.toCharArray(), 0, stringContents.length());
        } else if (node2 instanceof Property) {
            s = ((Property)node2).toString();
            handler.characters(s.toCharArray(), 0, s.length());
        }
        handler.endElement(PAN_NS, null, tagName);
    }
}

