/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.output;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.DoubleProperty;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.dml.data.ListResource;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.ProtectedHashResource;
import org.quattor.pan.dml.data.ProtectedListResource;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.output.AbstractFormatter;
import org.quattor.pan.tasks.FinalResult;

public class JsonFormatter
extends AbstractFormatter {
    private static final JsonFormatter instance = new JsonFormatter();

    private JsonFormatter() {
        super("json", "json");
    }

    protected JsonFormatter(String suffix, String key2) {
        super(suffix, key2);
    }

    public static JsonFormatter getInstance() {
        return instance;
    }

    @Override
    protected void write(FinalResult result, PrintWriter ps) throws Exception {
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)BooleanProperty.class), new PropertySerializer()).registerTypeAdapter((Type)((Object)DoubleProperty.class), new PropertySerializer()).registerTypeAdapter((Type)((Object)LongProperty.class), new PropertySerializer()).registerTypeAdapter((Type)((Object)StringProperty.class), new PropertySerializer()).registerTypeAdapter((Type)((Object)HashResource.class), new HashSerializer()).registerTypeAdapter((Type)((Object)ProtectedHashResource.class), new HashSerializer()).registerTypeAdapter((Type)((Object)ListResource.class), new ListSerializer()).registerTypeAdapter((Type)((Object)ProtectedListResource.class), new ListSerializer()).setPrettyPrinting().create();
        ps.write(gson.toJson(result.getRoot()));
        ps.close();
    }

    private static class ListSerializer
    implements JsonSerializer<ListResource> {
        private ListSerializer() {
        }

        @Override
        public JsonElement serialize(ListResource src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray array2 = new JsonArray();
            for (Resource.Entry entry : src) {
                JsonElement value = context.serialize(entry.getValue());
                array2.add(value);
            }
            return array2;
        }
    }

    private static class HashSerializer
    implements JsonSerializer<HashResource> {
        private HashSerializer() {
        }

        @Override
        public JsonElement serialize(HashResource src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject map2 = new JsonObject();
            for (Resource.Entry entry : src) {
                String property = ((Property)entry.getKey()).toString();
                JsonElement value = context.serialize(entry.getValue());
                map2.add(property, value);
            }
            return map2;
        }
    }

    private static class PropertySerializer
    implements JsonSerializer<Property> {
        private PropertySerializer() {
        }

        @Override
        public JsonElement serialize(Property src, Type typeOfSrc, JsonSerializationContext context) {
            if (src instanceof BooleanProperty) {
                return new JsonPrimitive(((BooleanProperty)src).getValue());
            }
            if (src instanceof DoubleProperty) {
                return new JsonPrimitive(((DoubleProperty)src).getValue());
            }
            if (src instanceof LongProperty) {
                return new JsonPrimitive(((LongProperty)src).getValue());
            }
            return new JsonPrimitive(src.getValue().toString());
        }
    }
}

