/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.output;

import java.io.File;
import java.util.HashMap;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.SystemException;
import org.quattor.pan.output.DotFormatter;
import org.quattor.pan.output.Formatter;
import org.quattor.pan.output.JsonFormatter;
import org.quattor.pan.output.JsonGzipFormatter;
import org.quattor.pan.output.NullFormatter;
import org.quattor.pan.output.PanFormatter;
import org.quattor.pan.output.PanGzipFormatter;
import org.quattor.pan.output.XmlFormatter;
import org.quattor.pan.output.XmlGzipFormatter;
import org.quattor.pan.utils.MessageUtils;

public class FormatterUtils {
    private static final HashMap<String, Formatter> formatters;
    private static final Formatter defaultFormatter;

    public static Formatter getFormatterInstance(String name2) {
        String key2 = name2 != null ? name2.toLowerCase() : "";
        return formatters.get(key2);
    }

    public static Formatter getDefaultFormatterInstance() {
        return defaultFormatter;
    }

    public static void createParentDirectories(File file2) {
        boolean created;
        File parent = file2.getParentFile();
        if (!(parent.isDirectory() || (created = parent.mkdirs()) || parent.isDirectory())) {
            throw new SystemException(MessageUtils.format("MSG_CANNOT_CREATE_OUTPUT_DIRECTORY", parent.getAbsolutePath()), parent);
        }
    }

    public static void setOutputTimestamp(File absolutePath, long timestamp) {
        if (!absolutePath.setLastModified(timestamp)) {
            // empty if block
        }
    }

    static {
        Formatter[] instances;
        formatters = new HashMap();
        for (Formatter f : instances = new Formatter[]{DotFormatter.getInstance(), PanFormatter.getInstance(), PanGzipFormatter.getInstance(), XmlFormatter.getInstance(), XmlGzipFormatter.getInstance(), JsonFormatter.getInstance(), JsonGzipFormatter.getInstance(), NullFormatter.getInstance()}) {
            String key2 = f.getFormatKey().toLowerCase();
            Formatter existingValue = formatters.put(key2, f);
            if (existingValue == null) continue;
            throw CompilerError.create("MSG_DUPLICATE_FORMATTER_KEY", new Object[0]);
        }
        defaultFormatter = PanFormatter.getInstance();
    }
}

