/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.output;

import java.io.PrintWriter;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.output.AbstractFormatter;
import org.quattor.pan.tasks.FinalResult;

public class DotFormatter
extends AbstractFormatter {
    private static final DotFormatter instance = new DotFormatter();

    private DotFormatter() {
        super("dot", "dot");
    }

    public static DotFormatter getInstance() {
        return instance;
    }

    @Override
    protected void write(FinalResult result, PrintWriter ps) throws Exception {
        Element root2 = result.getRoot();
        String rootName = "profile";
        this.writeHeader(rootName, ps);
        this.writeRoot(rootName, root2, ps);
        this.writeFooter(ps);
    }

    private void writeRoot(String myName, Element node2, PrintWriter ps) {
        String tagName = node2.getTypeAsString();
        if (node2 instanceof StringProperty && !"string".equals(tagName)) {
            tagName = "string";
        }
        String myPath = "/" + myName;
        ps.append("\"" + myPath + "\" [ label = \"" + myName + "\"]\n");
        if (node2 instanceof Resource) {
            Resource resource2 = (Resource)node2;
            for (Resource.Entry entry : resource2) {
                String nameChild = ((Property)entry.getKey()).toString();
                this.writeChild(myPath, nameChild, (Element)entry.getValue(), ps);
            }
        }
    }

    private void writeChild(String parentPath, String myName, Element node2, PrintWriter ps) {
        String type2 = node2.getTypeAsString();
        String myPath = parentPath + "/" + myName;
        if (node2 instanceof Resource) {
            ps.append("\"" + myPath + "\" [ label = \"" + myName + "\" ]\n");
            ps.append("\"" + parentPath + "\" -> \"" + myPath + "\"\n");
            Resource resource2 = (Resource)node2;
            for (Resource.Entry entry : resource2) {
                String nameChild = ((Property)entry.getKey()).toString();
                this.writeChild(myPath, nameChild, (Element)entry.getValue(), ps);
            }
        } else {
            String s = ((Property)node2).toString();
            String quote = "string".equals(type2) ? "'" : "";
            s = this.fixString(s, quote);
            ps.append("\"" + myPath + "\" [ label = \"" + myName + "\\n" + s + "\" ]\n");
            ps.append("\"" + parentPath + "\" -> \"" + myPath + "\"\n");
        }
    }

    private void writeHeader(String rootName, PrintWriter ps) {
        ps.append("digraph \"" + rootName + "\" {\nbgcolor = beige\nnode [ color = black, shape = box, fontname=Helvetica ]\nedge [ color = black ]\n");
    }

    private void writeFooter(PrintWriter ps) {
        ps.append("}\n");
    }

    private String fixString(String s, String quote) {
        StringBuilder sb = new StringBuilder(quote);
        sb.append(s.replaceAll("[\\n\\r]+", " "));
        if (sb.length() > 15) {
            sb.setLength(12);
            sb.append("...");
        }
        sb.append(quote);
        return sb.toString();
    }
}

