/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.output;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.output.Formatter;
import org.quattor.pan.tasks.FinalResult;

public abstract class AbstractFormatter
implements Formatter {
    private final String suffix;
    private final String key;

    protected AbstractFormatter(String suffix, String key2) {
        this.suffix = suffix;
        this.key = key2;
    }

    @Override
    public URI getResultURI(String objectName) {
        try {
            return new URI(objectName + "." + this.suffix);
        }
        catch (URISyntaxException e2) {
            throw new CompilerError("invalid object template name encountered: " + objectName);
        }
    }

    @Override
    public String getFormatKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(FinalResult result, URI outputURI) throws Exception {
        PrintWriter pw = null;
        try {
            pw = this.getPrintWriter(new File(outputURI));
            this.write(result, pw);
        }
        catch (Throwable throwable) {
            AbstractFormatter.closeReliably(pw);
            throw throwable;
        }
        AbstractFormatter.closeReliably(pw);
    }

    protected PrintWriter getPrintWriter(File file2) throws Exception {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
    }

    protected abstract void write(FinalResult var1, PrintWriter var2) throws Exception;

    private static void closeReliably(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

