/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.exceptions;

import java.io.File;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;

public class SyntaxException
extends Exception {
    private SourceRange sourceRange;
    private File file;

    public SyntaxException(String message, SourceRange sourceRange) {
        this(message, sourceRange, null);
    }

    public SyntaxException(String message, SourceRange sourceRange, File file2) {
        super(message);
        this.sourceRange = sourceRange;
        this.file = file2;
    }

    public static SyntaxException create(SourceRange sourceRange, String msgkey, Object ... args) {
        String msg = MessageUtils.format(msgkey, args);
        return new SyntaxException(msg, sourceRange);
    }

    public static SyntaxException create(SourceRange sourceRange, File file2, String msgkey, Object ... args) {
        String msg = MessageUtils.format(msgkey, args);
        return new SyntaxException(msg, sourceRange, file2);
    }

    public static SyntaxException create(SourceRange sourceRange, EvaluationException ee) {
        String msg = ee.getSimpleMessage();
        return new SyntaxException(msg, sourceRange);
    }

    public SyntaxException addExceptionInfo(SourceRange sourceRange, File file2) {
        if (this.sourceRange == null && sourceRange != null) {
            this.sourceRange = sourceRange;
        }
        if (this.file == null && file2 != null) {
            this.file = file2;
        }
        return this;
    }

    public String getSimpleMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder("syntax error [");
        sb.append(this.file != null ? this.file.toString() : "?");
        sb.append(":");
        sb.append(this.sourceRange != null ? this.sourceRange.toString() : "?");
        sb.append("]\n");
        sb.append(super.getMessage());
        sb.append("\n");
        return sb.toString();
    }
}

