/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.exceptions;

import java.util.List;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.Path;
import org.quattor.pan.utils.Term;

public class InvalidTermException
extends Exception {
    private String errorPath = null;
    private String actualType = null;

    public InvalidTermException(String message) {
        super(message);
    }

    public InvalidTermException setInfo(Term[] terms, int index2, String actualType) {
        this.actualType = actualType;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= index2; ++i) {
            if (i > 0) {
                sb.append("/");
            }
            sb.append(terms[i].toString());
        }
        this.errorPath = sb.toString();
        return this;
    }

    public InvalidTermException setVariableInfo(List<Term> terms, int index2, String actualType) {
        this.actualType = actualType;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= index2; ++i) {
            sb.append("[");
            sb.append(terms.get(i).toString());
            sb.append("]");
        }
        this.errorPath = sb.toString();
        return this;
    }

    public String formatMessage(Path path2) {
        StringBuilder sb = new StringBuilder();
        if (path2.isAbsolute()) {
            sb.append("/");
        } else if (path2.isExternal()) {
            sb.append(path2.getAuthority());
            sb.append(":");
        }
        if (this.errorPath != null) {
            sb.append(this.errorPath);
        }
        return MessageUtils.format("MSG_INVALID_PATH_DEREFERENCE", this.actualType, this.getMessage(), sb.toString(), path2.toString());
    }

    public String formatVariableMessage(String name2, Term[] terms) {
        StringBuilder sb = new StringBuilder();
        sb.append(name2);
        if (terms != null) {
            for (Term term : terms) {
                sb.append("[");
                sb.append(term.toString());
                sb.append("]");
            }
        }
        return MessageUtils.format("MSG_INVALID_PATH_DEREFERENCE", this.actualType, this.getMessage(), name2 + this.errorPath, name2);
    }
}

