/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import clojure.lang.AFn;
import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.NumberProperty;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;

public final class UnaryPlus
extends AbstractOperation {
    private UnaryPlus(SourceRange sourceRange, Operation ... operations) {
        super(sourceRange, operations);
        assert (operations.length == 1);
    }

    public static Operation newOperation(SourceRange sourceRange, Operation ... ops) throws SyntaxException {
        assert (ops.length == 1);
        AFn result = null;
        if (ops[0] instanceof Element) {
            try {
                NumberProperty number = (NumberProperty)ops[0];
                result = number;
            }
            catch (ClassCastException cce) {
                throw SyntaxException.create(sourceRange, "MSG_INVALID_ARGS_UPLUS", new Object[0]);
            }
            catch (EvaluationException ee) {
                throw SyntaxException.create(sourceRange, ee);
            }
        } else {
            result = new UnaryPlus(sourceRange, ops);
        }
        return result;
    }

    @Override
    public Element execute(Context context) {
        try {
            Element[] args = this.calculateArgs(context);
            return args[0];
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_ARGS_UPLUS", new Object[0]), this.sourceRange);
        }
    }
}

