/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.DoubleProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.NumberProperty;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;

public final class UnaryMinus
extends AbstractOperation {
    private UnaryMinus(SourceRange sourceRange, Operation ... operations) {
        super(sourceRange, operations);
        assert (operations.length == 1);
    }

    public static Operation newOperation(SourceRange sourceRange, Operation ... ops) throws SyntaxException {
        assert (ops.length == 1);
        Operation result = null;
        if (ops[0] instanceof Element) {
            try {
                NumberProperty a = (NumberProperty)ops[0];
                result = UnaryMinus.execute(a);
            }
            catch (ClassCastException cce) {
                throw new EvaluationException(MessageUtils.format("MSG_INVALID_ARGS_UMINUS", new Object[0]), sourceRange);
            }
            catch (EvaluationException ee) {
                throw SyntaxException.create(sourceRange, ee);
            }
        } else {
            result = new UnaryMinus(sourceRange, ops);
        }
        return result;
    }

    @Override
    public Element execute(Context context) {
        try {
            Element[] args = this.calculateArgs(context);
            NumberProperty a = (NumberProperty)args[0];
            return UnaryMinus.execute(a);
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_ARGS_UMINUS", new Object[0]), this.sourceRange);
        }
    }

    private static Element execute(NumberProperty a) {
        NumberProperty result = null;
        if (a instanceof LongProperty) {
            long l1 = (Long)a.getValue();
            result = LongProperty.getInstance(-l1);
        } else if (a instanceof DoubleProperty) {
            double d1 = (Double)a.getValue();
            result = DoubleProperty.getInstance(-d1);
        }
        return result;
    }
}

